/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.builders;

import java.util.List;
import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.builders.QueryTreeBuilder;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.AnyQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.standard.builders.StandardQueryBuilder;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class AnyQueryNodeBuilder
implements StandardQueryBuilder {
    public BooleanQuery build(QueryNode queryNode) throws QueryNodeException {
        AnyQueryNode andNode = (AnyQueryNode)queryNode;
        BooleanQuery bQuery = new BooleanQuery();
        List<QueryNode> children = andNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                Object obj = child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                if (obj == null) continue;
                Query query = (Query)obj;
                try {
                    bQuery.add(query, BooleanClause.Occur.SHOULD);
                }
                catch (BooleanQuery.TooManyClauses ex) {
                    throw new QueryNodeException((Message)new MessageImpl(QueryParserMessages.EMPTY_MESSAGE), (Throwable)ex);
                }
            }
        }
        bQuery.setMinimumNumberShouldMatch(andNode.getMinimumMatchingElements());
        return bQuery;
    }
}

