/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf.jmx;

import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.EasyConf;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public class ComponentConfigurationDynamicMBean
implements DynamicMBean {
    public static final String RELOAD_OPERATION_NAME = "reloadConfiguration";
    public static final String NEW_PROPERTY_OPERATION_NAME = "newProperty";
    public static final String[] RELOAD_OPERATION_SIGNATURE = new String[0];
    public static final String[] NEW_PROPERTY_OPERATION_SIGNATURE_1 = new String[]{(class$java$lang$String == null ? (class$java$lang$String = ComponentConfigurationDynamicMBean.class$("java.lang.String")) : class$java$lang$String).toString()};
    public static final String[] NEW_PROPERTY_OPERATION_SIGNATURE_2 = new String[]{(class$java$lang$String == null ? (class$java$lang$String = ComponentConfigurationDynamicMBean.class$("java.lang.String")) : class$java$lang$String).toString(), (class$java$lang$Object == null ? (class$java$lang$Object = ComponentConfigurationDynamicMBean.class$("java.lang.Object")) : class$java$lang$Object).toString()};
    private static final String NEW_PROPERTY_OPERATION_DESCRIPTION_1 = "Add new property to the Configuration Component. The Param is the property name. Must not exists another property with the same name.";
    private static final String NEW_PROPERTY_OPERATION_DESCRIPTION_2 = "Add new property to the Configuration Component. The Param is the property name. Must not exists another property with the same name. The second param is the initial value of the new property";
    private static final String RELOAD_OPERATION_DESCRIPTION = "Reloads the configuration";
    private static final String CONSTRUCTOR_DESCRIPTION_1 = "Constructs new MBean with the configuration of the named Component";
    private String componentName;
    private ComponentConfiguration componentConfiguration;
    private MBeanAttributeInfo[] attributesInfo;
    private Map modifiedProperties;
    private Map newPropeties;
    private MBeanOperationInfo[] operationInfo;
    private MBeanConstructorInfo[] constructorsInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ComponentConfigurationDynamicMBean(ComponentConfiguration component) {
        this.componentName = component.getComponentName();
        this.componentConfiguration = component;
        this.init();
    }

    public ComponentConfigurationDynamicMBean(String componentName) {
        this.componentName = componentName;
        this.componentConfiguration = EasyConf.getConfiguration(componentName);
        this.init();
    }

    private void init() {
        this.modifiedProperties = new HashMap();
        this.newPropeties = new HashMap();
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ComponentProperties prop = this.componentConfiguration.getProperties();
        if (this.modifiedProperties.containsKey(attributeName)) {
            return this.modifiedProperties.get(attributeName);
        }
        if (prop.containsKey(attributeName)) {
            return prop.getProperty(attributeName);
        }
        if (this.newPropeties.containsKey(attributeName)) {
            return this.newPropeties.get(attributeName);
        }
        throw new AttributeNotFoundException(attributeName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.componentConfiguration.getProperties().containsKey(attribute.getName())) {
            this.modifiedProperties.put(attribute.getName(), attribute.getValue());
        } else if (this.newPropeties.containsKey(attribute.getName())) {
            this.newPropeties.put(attribute.getName(), attribute.getValue());
        } else {
            throw new AttributeNotFoundException(attribute.getName());
        }
    }

    public AttributeList getAttributes(String[] attributesNames) {
        HashSet<String> includedAttributeNames = new HashSet<String>();
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            String attributeName = attributesNames[i];
            if (includedAttributeNames.contains(attributeName)) continue;
            includedAttributeNames.add(attributeName);
            try {
                Object value = this.getAttribute(attributeName);
                Attribute attribute = new Attribute(attributeName, value);
                attributeList.add(attribute);
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList modifieds = new AttributeList();
        Iterator it = ((AbstractList)attributes).iterator();
        while (it.hasNext()) {
            Attribute attribute = (Attribute)it.next();
            try {
                this.setAttribute(attribute);
                modifieds.add(attribute);
            }
            catch (AttributeNotFoundException e) {
            }
            catch (InvalidAttributeValueException e) {
            }
            catch (MBeanException e) {
            }
            catch (ReflectionException e) {}
        }
        return modifieds;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName.equals(RELOAD_OPERATION_NAME)) {
            this.reloadConfiguration();
            return null;
        }
        if (operationName.equals(NEW_PROPERTY_OPERATION_NAME)) {
            if (signature.length == 1) {
                this.newProperty((String)params[0]);
            } else if (signature.length == 2) {
                this.newProperty((String)params[0], params[1]);
            } else {
                throw new MBeanException(new IllegalArgumentException("Operation not found in MBEan: " + operationName + "(" + signature + ")"));
            }
            return null;
        }
        throw new MBeanException(new IllegalArgumentException("Operation not found in MBEan: " + operationName + "(" + signature + ")"));
    }

    private void reloadConfiguration() {
        EasyConf.refreshComponent(this.componentName);
        this.componentConfiguration = EasyConf.getConfiguration(this.componentName);
    }

    private void newProperty(String propertyName) throws MBeanException {
        this.newProperty(propertyName, null);
    }

    private void newProperty(String propertyName, Object value) throws MBeanException {
        ComponentProperties prop = this.componentConfiguration.getProperties();
        if (this.newPropeties.containsKey(propertyName) || prop.containsKey(propertyName)) {
            throw new MBeanException(new IllegalArgumentException("Cannot add new propert whith name: " + propertyName + ". There is a property whith that name yet"));
        }
        this.newPropeties.put(propertyName, value);
    }

    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().toString(), "Easyconf component: " + this.componentName, this.getAttributeInfo(), this.getConsturctorsInfo(), this.getOperationInfo(), null);
    }

    protected MBeanAttributeInfo[] getAttributeInfo() {
        if (this.attributesInfo == null) {
            ComponentProperties properties = this.componentConfiguration.getProperties();
            ArrayList<MBeanAttributeInfo> auxList = new ArrayList<MBeanAttributeInfo>();
            Iterator it = properties.getKeys();
            while (it.hasNext()) {
                String propertyName = (String)it.next();
                Object value = properties.getProperty(propertyName);
                String type = value.getClass().getName();
                boolean isIs = value.getClass().equals(class$java$lang$Boolean == null ? ComponentConfigurationDynamicMBean.class$("java.lang.Boolean") : class$java$lang$Boolean);
                MBeanAttributeInfo attributeInfo = new MBeanAttributeInfo(propertyName, type, "Easyconf " + this.componentName + " component property: " + propertyName, true, true, isIs);
                auxList.add(attributeInfo);
                this.attributesInfo = auxList.toArray(new MBeanAttributeInfo[auxList.size()]);
            }
        }
        return this.attributesInfo;
    }

    protected MBeanOperationInfo[] getOperationInfo() {
        if (this.operationInfo == null) {
            this.operationInfo = new MBeanOperationInfo[]{new MBeanOperationInfo(NEW_PROPERTY_OPERATION_NAME, NEW_PROPERTY_OPERATION_DESCRIPTION_1, new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", (class$java$lang$String == null ? (class$java$lang$String = ComponentConfigurationDynamicMBean.class$("java.lang.String")) : class$java$lang$String).getName(), "Name of the new property")}, Void.TYPE.getName(), 1), new MBeanOperationInfo(NEW_PROPERTY_OPERATION_NAME, NEW_PROPERTY_OPERATION_DESCRIPTION_2, new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", (class$java$lang$String == null ? (class$java$lang$String = ComponentConfigurationDynamicMBean.class$("java.lang.String")) : class$java$lang$String).getName(), "Name of the new property"), new MBeanParameterInfo("value", (class$java$lang$Object == null ? (class$java$lang$Object = ComponentConfigurationDynamicMBean.class$("java.lang.Object")) : class$java$lang$Object).getName(), "Initial value of the new property")}, Void.TYPE.getName(), 1), new MBeanOperationInfo(RELOAD_OPERATION_NAME, RELOAD_OPERATION_DESCRIPTION, new MBeanParameterInfo[0], Void.TYPE.getName(), 1)};
        }
        return this.operationInfo;
    }

    protected MBeanConstructorInfo[] getConsturctorsInfo() {
        if (this.constructorsInfo == null) {
            Constructor<?> constructor = null;
            try {
                constructor = this.getClass().getConstructor(class$java$lang$String == null ? (class$java$lang$String = ComponentConfigurationDynamicMBean.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.constructorsInfo = new MBeanConstructorInfo[]{new MBeanConstructorInfo(CONSTRUCTOR_DESCRIPTION_1, constructor)};
        }
        return this.constructorsInfo;
    }

    protected ComponentConfiguration getComponentConfiguration() {
        return this.componentConfiguration;
    }

    protected void setComponentConfiguration(ComponentConfiguration componentConfiguration) {
        this.componentConfiguration = componentConfiguration;
    }

    private boolean propertyExists(String property) {
        if (this.componentConfiguration.getProperties().containsKey(property)) {
            return true;
        }
        return this.newPropeties.containsKey(property);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

