/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.staging;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MergeLayoutPrototypesThreadLocal {
    private static ThreadLocal<Boolean> _inProgress = new AutoResetThreadLocal<Boolean>(MergeLayoutPrototypesThreadLocal.class + "._inProgress", false);
    private static ThreadLocal<Set<MethodKey>> _mergeComplete = new AutoResetThreadLocal(MergeLayoutPrototypesThreadLocal.class + "._mergeComplete", new HashSet());

    public static void clearMergeComplete() {
        _mergeComplete.remove();
    }

    public static boolean isInProgress() {
        return _inProgress.get();
    }

    public static boolean isMergeComplete(Method method, Object[] arguments) {
        Set<MethodKey> methodKeys = _mergeComplete.get();
        return methodKeys.contains(new MethodKey(method, arguments));
    }

    public static void setInProgress(boolean inProgress) {
        _inProgress.set(inProgress);
    }

    public static void setMergeComplete(Method method, Object[] arguments) {
        Set<MethodKey> methodKeys = _mergeComplete.get();
        methodKeys.add(new MethodKey(method, arguments));
        MergeLayoutPrototypesThreadLocal.setInProgress(false);
    }

    private static class MethodKey {
        private final Object[] _arguments;
        private final Method _method;

        public MethodKey(Method method, Object[] arguments) {
            this._method = method;
            this._arguments = arguments;
        }

        public int hashCode() {
            int hashCode = this._method.hashCode();
            if (this._arguments != null) {
                Object[] objectArray = this._arguments;
                int n = this._arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    hashCode = obj == null ? HashUtil.hash(hashCode, 0) : HashUtil.hash(hashCode, obj.hashCode());
                    ++n2;
                }
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            MethodKey methodKey = (MethodKey)obj;
            return Validator.equals(this._method, methodKey._method) && Arrays.equals(this._arguments, methodKey._arguments);
        }
    }
}

