/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.FacetedSearcher;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.List;
import java.util.Map;

public class AlternateKeywordQueryHitsProcessor
implements HitsProcessor {
    @Override
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        if (hits.getLength() > 0) {
            return true;
        }
        Map<String, List<String>> spellCheckResults = hits.getSpellCheckResults();
        if (spellCheckResults == null) {
            return true;
        }
        String spellCheckedKeywords = hits.getCollatedSpellCheckResult();
        searchContext.overrideKeywords(spellCheckedKeywords);
        Object[] querySuggestions = SearchEngineUtil.suggestKeywordQueries(searchContext, 5);
        if (ArrayUtil.isNotEmpty(querySuggestions)) {
            searchContext.setKeywords((String)querySuggestions[0]);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHitsProcessingEnabled(false);
        Indexer indexer = FacetedSearcher.getInstance();
        Hits alternateResults = indexer.search(searchContext);
        hits.copy(alternateResults);
        return true;
    }
}

