/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class PrepareMessage
extends RepairMessage {
    public static final RepairMessage.MessageSerializer serializer = new PrepareMessageSerializer(false);
    public static final RepairMessage.MessageSerializer globalSerializer = new PrepareMessageSerializer(true);
    public final List<UUID> cfIds;
    public final Collection<Range<Token>> ranges;
    public final UUID parentRepairSession;
    public final boolean isIncremental;

    public PrepareMessage(UUID parentRepairSession, List<UUID> cfIds, Collection<Range<Token>> ranges, boolean isIncremental, boolean isGlobal) {
        super(isGlobal ? RepairMessage.Type.PREPARE_GLOBAL_MESSAGE : RepairMessage.Type.PREPARE_MESSAGE, null);
        this.parentRepairSession = parentRepairSession;
        this.cfIds = cfIds;
        this.ranges = ranges;
        this.isIncremental = isIncremental;
    }

    public String toString() {
        return "PrepareMessage{cfIds='" + this.cfIds + '\'' + ", ranges=" + this.ranges + ", parentRepairSession=" + this.parentRepairSession + ", isIncremental=" + this.isIncremental + '}';
    }

    public static class PrepareMessageSerializer
    implements RepairMessage.MessageSerializer<PrepareMessage> {
        private final boolean isGlobal;

        public PrepareMessageSerializer(boolean global) {
            this.isGlobal = global;
        }

        @Override
        public void serialize(PrepareMessage message, DataOutputPlus out, int version) throws IOException {
            out.writeInt(message.cfIds.size());
            for (UUID uUID : message.cfIds) {
                UUIDSerializer.serializer.serialize(uUID, out, version);
            }
            UUIDSerializer.serializer.serialize(message.parentRepairSession, out, version);
            out.writeInt(message.ranges.size());
            for (Range range : message.ranges) {
                MessagingService.validatePartitioner(range);
                Range.tokenSerializer.serialize(range, out, version);
            }
            out.writeBoolean(message.isIncremental);
        }

        @Override
        public PrepareMessage deserialize(DataInput in, int version) throws IOException {
            int cfIdCount = in.readInt();
            ArrayList<UUID> cfIds = new ArrayList<UUID>(cfIdCount);
            for (int i = 0; i < cfIdCount; ++i) {
                cfIds.add(UUIDSerializer.serializer.deserialize(in, version));
            }
            UUID parentRepairSession = UUIDSerializer.serializer.deserialize(in, version);
            int rangeCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangeCount);
            for (int i = 0; i < rangeCount; ++i) {
                ranges.add((Range)Range.tokenSerializer.deserialize(in, MessagingService.globalPartitioner(), version));
            }
            boolean isIncremental = in.readBoolean();
            return new PrepareMessage(parentRepairSession, cfIds, ranges, isIncremental, this.isGlobal);
        }

        @Override
        public long serializedSize(PrepareMessage message, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            long size = sizes.sizeof(message.cfIds.size());
            for (UUID uUID : message.cfIds) {
                size += UUIDSerializer.serializer.serializedSize(uUID, version);
            }
            size += UUIDSerializer.serializer.serializedSize(message.parentRepairSession, version);
            size += (long)sizes.sizeof(message.ranges.size());
            for (Range range : message.ranges) {
                size += Range.tokenSerializer.serializedSize(range, version);
            }
            return size += (long)sizes.sizeof(message.isIncremental);
        }
    }
}

