/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.permissions;

import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import java.util.WeakHashMap;

public final class PermissionFactory {
    private static WeakHashMap<Integer, PagePermission> c_cache = new WeakHashMap();

    private PermissionFactory() {
    }

    public static final PagePermission getPagePermission(WikiPage page, String actions) {
        return PermissionFactory.getPagePermission(page.getWiki(), page.getName(), actions);
    }

    public static final PagePermission getPagePermission(String page, String actions) {
        return PermissionFactory.getPagePermission("", page, actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PagePermission getPagePermission(String wiki, String page, String actions) {
        PagePermission perm;
        Integer key = wiki.hashCode() ^ page.hashCode() ^ actions.hashCode();
        WeakHashMap<Integer, PagePermission> weakHashMap = c_cache;
        synchronized (weakHashMap) {
            perm = c_cache.get(key);
        }
        if (perm == null) {
            if (wiki.length() > 0) {
                page = wiki + ":" + page;
            }
            perm = new PagePermission(page, actions);
            weakHashMap = c_cache;
            synchronized (weakHashMap) {
                c_cache.put(key, perm);
            }
        }
        return perm;
    }
}

