/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.extractors;

import java.util.HashMap;
import java.util.Map;
import org.scribe.exceptions.OAuthParametersMissingException;
import org.scribe.extractors.BaseStringExtractor;
import org.scribe.model.OAuthRequest;
import org.scribe.utils.MapUtils;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

public class BaseStringExtractorImpl
implements BaseStringExtractor {
    private static final String AMPERSAND_SEPARATED_STRING = "%s&%s&%s";

    public String extract(OAuthRequest request) {
        this.checkPreconditions(request);
        String verb = URLUtils.percentEncode(request.getVerb().name());
        String url = URLUtils.percentEncode(request.getSanitizedUrl());
        String params = this.getSortedAndEncodedParams(request);
        return String.format(AMPERSAND_SEPARATED_STRING, verb, url, params);
    }

    private String getSortedAndEncodedParams(OAuthRequest request) {
        Map<String, String> params = new HashMap<String, String>();
        params.putAll(request.getQueryStringParams());
        params.putAll(request.getBodyParams());
        params.putAll(request.getOauthParameters());
        params = MapUtils.sort(params);
        return URLUtils.percentEncode(URLUtils.formURLEncodeMap(params));
    }

    private void checkPreconditions(OAuthRequest request) {
        Preconditions.checkNotNull(request, "Cannot extract base string from null object");
        if (request.getOauthParameters() == null || request.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(request);
        }
    }
}

