/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedDatabaseBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    EmbeddedDatabaseBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedDatabaseFactoryBean.class);
        this.setDatabaseType(element, builder);
        this.setDatabasePopulator(element, builder);
        this.useIdAsDatabaseNameIfGiven(element, builder);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        return builder.getBeanDefinition();
    }

    private void useIdAsDatabaseNameIfGiven(Element element, BeanDefinitionBuilder builder) {
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            builder.addPropertyValue("databaseName", (Object)id);
        }
    }

    private void setDatabaseType(Element element, BeanDefinitionBuilder builder) {
        String type = element.getAttribute("type");
        if (StringUtils.hasText((String)type)) {
            builder.addPropertyValue("databaseType", (Object)type);
        }
    }

    private void setDatabasePopulator(Element element, BeanDefinitionBuilder builder) {
        List scripts = DomUtils.getChildElementsByTagName((Element)element, (String)"script");
        if (scripts.size() > 0) {
            builder.addPropertyValue("databasePopulator", (Object)this.createDatabasePopulator(scripts));
        }
    }

    private BeanDefinition createDatabasePopulator(List<Element> scripts) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ResourceDatabasePopulator.class);
        ArrayList<String> locations = new ArrayList<String>();
        for (Element scriptElement : scripts) {
            locations.add(scriptElement.getAttribute("location"));
        }
        BeanDefinitionBuilder resourcesFactory = BeanDefinitionBuilder.genericBeanDefinition(SortedResourcesFactoryBean.class);
        resourcesFactory.addConstructorArgValue(locations);
        builder.addPropertyValue("scripts", (Object)resourcesFactory.getBeanDefinition());
        return builder.getBeanDefinition();
    }
}

