/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.plugin.AbstractReferralPlugin;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.preferences.Preferences;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.log4j.Logger;

public class RecentChangesPlugin
extends AbstractReferralPlugin
implements WikiPlugin {
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_TIME_FORMAT = "timeFormat";
    public static final String PARAM_DATE_FORMAT = "dateFormat";
    private static final int DEFAULT_DAYS = 36500;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    private static Logger log = Logger.getLogger(RecentChangesPlugin.class);

    private boolean isSameDay(Date a, Date b2) {
        Calendar aa = Calendar.getInstance();
        aa.setTime(a);
        Calendar bb = Calendar.getInstance();
        bb.setTime(b2);
        return aa.get(1) == bb.get(1) && aa.get(6) == bb.get(6);
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        int since = TextUtil.parseIntParameter((String)params.get("since"), 36500);
        int spacing = 4;
        boolean showAuthor = true;
        boolean showChangenote = true;
        int tablewidth = 4;
        WikiEngine engine = context.getEngine();
        if ("compact".equals(params.get(PARAM_FORMAT))) {
            spacing = 0;
            showAuthor = false;
            showChangenote = false;
            tablewidth = 2;
        }
        GregorianCalendar sincedate = new GregorianCalendar();
        ((Calendar)sincedate).add(5, -since);
        log.debug((Object)("Calculating recent changes from " + sincedate.getTime()));
        Collection changes = engine.getRecentChanges();
        super.initialize(context, params);
        changes = super.filterCollection(changes);
        if (changes != null) {
            WikiPage pageref;
            Date lastmod;
            Date olddate = new Date(0L);
            DateFormat fmt = this.getDateFormat(context, params);
            DateFormat tfmt = this.getTimeFormat(context, params);
            table rt = new table();
            rt.setCellPadding(spacing).setClass("recentchanges");
            Iterator i = changes.iterator();
            while (i.hasNext() && !(lastmod = (pageref = (WikiPage)i.next()).getLastModified()).before(sincedate.getTime())) {
                if (!this.isSameDay(lastmod, olddate)) {
                    tr row = new tr();
                    td col = new td();
                    col.setColSpan(tablewidth).setClass("date");
                    col.addElement((Element)new b().addElement(fmt.format(lastmod)));
                    rt.addElement((Element)row);
                    row.addElement((Element)col);
                    olddate = lastmod;
                }
                String link = context.getURL(pageref instanceof Attachment ? WikiContext.ATTACH : WikiContext.VIEW, pageref.getName());
                a linkel = new a(link, engine.beautifyTitle(pageref.getName()));
                tr row = new tr();
                td col = new td().setWidth("30%").addElement((Element)linkel);
                if (pageref instanceof Attachment) {
                    linkel = new a().setHref(context.getURL(WikiContext.INFO, pageref.getName()));
                    linkel.setClass("infolink");
                    linkel.addElement((Element)new img().setSrc(context.getURL(WikiContext.NONE, "images/attachment_small.png")));
                    col.addElement((Element)linkel);
                }
                row.addElement((Element)col);
                rt.addElement((Element)row);
                if (pageref instanceof Attachment) {
                    row.addElement(new td(tfmt.format(lastmod)).setClass("lastchange"));
                } else {
                    td infocol = (td)new td().setClass("lastchange");
                    infocol.addElement((Element)new a(context.getURL(WikiContext.DIFF, pageref.getName(), "r1=-1"), tfmt.format(lastmod)));
                    row.addElement((Element)infocol);
                }
                if (showAuthor) {
                    String author = pageref.getAuthor();
                    td authorinfo = new td();
                    authorinfo.setClass("author");
                    if (author != null) {
                        if (engine.pageExists(author)) {
                            authorinfo.addElement((Element)new a(context.getURL(WikiContext.VIEW, author), author));
                        } else {
                            authorinfo.addElement(author);
                        }
                    } else {
                        authorinfo.addElement(context.getBundle("CoreResources").getString("common.unknownauthor"));
                    }
                    row.addElement((Element)authorinfo);
                }
                if (!showChangenote) continue;
                String changenote = (String)pageref.getAttribute("changenote");
                row.addElement(new td(changenote != null ? changenote : "").setClass("changenote"));
            }
            rt.setPrettyPrint(true);
            return rt.toString();
        }
        return "";
    }

    private DateFormat getTimeFormat(WikiContext context, Map params) {
        String formatString = this.get(params, DEFAULT_TIME_FORMAT, PARAM_TIME_FORMAT);
        if ("".equals(formatString.trim())) {
            return Preferences.getDateFormat(context, Preferences.TimeFormat.TIME);
        }
        return new SimpleDateFormat(formatString);
    }

    private DateFormat getDateFormat(WikiContext context, Map params) {
        String formatString = this.get(params, DEFAULT_DATE_FORMAT, PARAM_DATE_FORMAT);
        if ("".equals(formatString.trim())) {
            return Preferences.getDateFormat(context, Preferences.TimeFormat.DATE);
        }
        return new SimpleDateFormat(formatString);
    }

    private String get(Map params, String defaultValue, String paramName) {
        String value = (String)params.get(paramName);
        return null == value ? defaultValue : value;
    }
}

