/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.crypto;

import java.security.InvalidKeyException;
import java.security.SignatureException;
import net.oauth.jsontoken.crypto.HmacSHA256Signer;
import net.oauth.jsontoken.crypto.Verifier;

public class HmacSHA256Verifier
implements Verifier {
    private final HmacSHA256Signer signer;

    public HmacSHA256Verifier(byte[] verificationKey) throws InvalidKeyException {
        this.signer = new HmacSHA256Signer("verifier", null, verificationKey);
    }

    @Override
    public void verifySignature(byte[] source, byte[] signature) throws SignatureException {
        byte[] comparison = this.signer.sign(source);
        if (!this.compareBytes(signature, comparison)) {
            throw new SignatureException("signature did not verify");
        }
    }

    private boolean compareBytes(byte[] first, byte[] second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.length != second.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < first.length; ++i) {
            result = (byte)(result | first[i] ^ second[i]);
        }
        return result == 0;
    }
}

