/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JournalBaseTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException, SystemException {
        return JournalFolderLocalServiceUtil.getFolder((long)containerModelId);
    }

    public String getContainerModelClassName() {
        return JournalFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException, SystemException {
        List folders = JournalFolderLocalServiceUtil.getFolders((long)this.getGroupId(classPK), (long)parentContainerModelId, (int)start, (int)end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (JournalFolder curFolder : folders) {
            containerModels.add((ContainerModel)curFolder);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException, SystemException {
        return JournalFolderLocalServiceUtil.getFoldersCount((long)this.getGroupId(classPK), (long)parentContainerModelId);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException, SystemException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L) {
            if ((containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) == null) break;
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "home";
    }

    public String getTrashContainedModelName() {
        return "article";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalArticleLocalServiceUtil.searchCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        List articles = JournalArticleLocalServiceUtil.search((long)folder.getGroupId(), (long)classPK, (int)8, (int)start, (int)end);
        for (JournalArticle article : articles) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)JournalArticle.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(article.getResourcePrimKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalFolderLocalServiceUtil.getFoldersCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        List folders = JournalFolderLocalServiceUtil.getFolders((long)folder.getGroupId(), (long)classPK, (int)8, (int)start, (int)end);
        for (JournalFolder curFolder : folders) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)JournalFolder.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(curFolder.getPrimaryKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public boolean isMovable() {
        return true;
    }

    protected abstract long getGroupId(long var1) throws PortalException, SystemException;
}

