/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ntlm;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.ntlm.NetlogonConnection;
import com.liferay.portal.security.ntlm.NtlmLogonException;
import com.liferay.portal.security.ntlm.NtlmServiceAccount;
import com.liferay.portal.security.ntlm.NtlmUserAccount;
import com.liferay.portal.security.ntlm.msrpc.NetlogonAuthenticator;
import com.liferay.portal.security.ntlm.msrpc.NetlogonIdentityInfo;
import com.liferay.portal.security.ntlm.msrpc.NetlogonNetworkInfo;
import com.liferay.portal.security.ntlm.msrpc.NetlogonValidationSamInfo;
import com.liferay.portal.security.ntlm.msrpc.NetrLogonSamLogon;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.UnicodeString;
import jcifs.smb.SmbException;

public class Netlogon {
    private static Log _log = LogFactoryUtil.getLog(Netlogon.class);
    private String _domainController;
    private String _domainControllerName;
    private NtlmServiceAccount _ntlmServiceAccount;

    static {
        DcerpcBinding.addInterface((String)"netlogon", (String)"12345678-1234-abcd-ef00-01234567cffb:1.0");
    }

    public NtlmUserAccount logon(String domain, String userName, String workstation, byte[] serverChallenge, byte[] ntResponse, byte[] lmResponse) throws NtlmLogonException {
        NetlogonConnection netlogonConnection = new NetlogonConnection();
        try {
            netlogonConnection.connect(this._domainController, this._domainControllerName, this._ntlmServiceAccount);
            NetlogonAuthenticator netlogonAuthenticator = netlogonConnection.computeNetlogonAuthenticator();
            NetlogonIdentityInfo netlogonIdentityInfo = new NetlogonIdentityInfo(domain, 2080, 0, 0, userName, workstation);
            NetlogonNetworkInfo netlogonNetworkInfo = new NetlogonNetworkInfo(netlogonIdentityInfo, serverChallenge, ntResponse, lmResponse);
            NetrLogonSamLogon netrLogonSamLogon = new NetrLogonSamLogon(this._domainControllerName, this._ntlmServiceAccount.getComputerName(), netlogonAuthenticator, new NetlogonAuthenticator(), 2, netlogonNetworkInfo, 2, new NetlogonValidationSamInfo(), 0);
            DcerpcHandle dcerpcHandle = netlogonConnection.getDcerpcHandle();
            dcerpcHandle.sendrecv((DcerpcMessage)netrLogonSamLogon);
            if (netrLogonSamLogon.getStatus() == 0) {
                NetlogonValidationSamInfo netlogonValidationSamInfo = netrLogonSamLogon.getNetlogonValidationSamInfo();
                UnicodeString name = new UnicodeString(netlogonValidationSamInfo.getEffectiveName(), false);
                NtlmUserAccount ntlmUserAccount = new NtlmUserAccount(name.toString());
                return ntlmUserAccount;
            }
            try {
                SmbException smbe = new SmbException(netrLogonSamLogon.getStatus(), false);
                throw new NtlmLogonException("Unable to authenticate user: " + smbe.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new NtlmLogonException("Unable to authenticate due to invalid encryption algorithm", nsae);
            }
            catch (IOException ioe) {
                throw new NtlmLogonException("Unable to authenticate due to communication failure with server", ioe);
            }
        }
        finally {
            try {
                netlogonConnection.disconnect();
            }
            catch (Exception e2) {
                _log.error((Object)"Unable to disconnect Netlogon connection", (Throwable)e2);
            }
        }
    }

    public void setConfiguration(String domainController, String domainControllerName, NtlmServiceAccount ntlmServiceAccount) {
        this._domainController = domainController;
        this._domainControllerName = domainControllerName;
        this._ntlmServiceAccount = ntlmServiceAccount;
    }
}

