/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.Permissions;

public class SocketChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(SocketChecker.class);
    private Permissions _permissions = new Permissions();

    @Override
    public void afterPropertiesSet() {
        this.initAcceptHostsAndPorts();
        this.initConnectHostsAndPorts();
        this.initListenPorts();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String actions = permission.getActions();
        if (actions.equals("resolve")) {
            return null;
        }
        String name = permission.getName();
        int index = name.indexOf(":");
        int port = GetterUtil.getInteger((String)name.substring(index + 1));
        String key = null;
        String value = null;
        if (actions.contains("accept")) {
            key = "security-manager-sockets-accept";
            value = name;
        } else if (actions.contains("connect")) {
            key = "security-manager-sockets-connect";
            value = name;
        } else if (actions.contains("listen")) {
            key = "security-manager-sockets-listen";
            value = String.valueOf(port);
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        String actions = permission.getActions();
        String name = permission.getName();
        if (!this._permissions.implies(permission)) {
            this.logSecurityException(_log, "Attempted " + actions + " for address " + name);
            return false;
        }
        return true;
    }

    protected void initAcceptHostsAndPorts() {
        String[] networkParts;
        String[] stringArray = networkParts = this.getPropertyArray("security-manager-sockets-accept");
        int n = networkParts.length;
        int n2 = 0;
        while (n2 < n) {
            String networkPart = stringArray[n2];
            this.initHostsAndPorts(networkPart, "accept");
            ++n2;
        }
    }

    protected void initConnectHostsAndPorts() {
        String[] networkParts;
        String[] stringArray = networkParts = this.getPropertyArray("security-manager-sockets-connect");
        int n = networkParts.length;
        int n2 = 0;
        while (n2 < n) {
            String networkPart = stringArray[n2];
            this.initHostsAndPorts(networkPart, "connect");
            ++n2;
        }
    }

    protected void initHostsAndPorts(String networkPart, String action) {
        SocketPermission socketPermission = new SocketPermission(networkPart, action);
        this._permissions.add(socketPermission);
    }

    protected void initListenPorts() {
        String[] listenParts;
        String[] stringArray = listenParts = this.getPropertyArray("security-manager-sockets-listen");
        int n = listenParts.length;
        int n2 = 0;
        while (n2 < n) {
            String listenPart = stringArray[n2];
            this.initListenPorts(listenPart);
            ++n2;
        }
    }

    protected void initListenPorts(String listenPart) {
        this.initHostsAndPorts("*:" + listenPart, "listen");
    }
}

