/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.QuerySuggester;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.StringPool;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BaseIndexSearcher
implements IndexSearcher,
QuerySuggester {
    private static Log _log = LogFactoryUtil.getLog(BaseIndexSearcher.class);
    private QuerySuggester _querySuggester;

    public void setQuerySuggester(QuerySuggester querySuggester) {
        this._querySuggester = querySuggester;
    }

    @Override
    public String spellCheckKeywords(SearchContext searchContext) throws SearchException {
        if (this._querySuggester == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No query suggester configured");
            }
            return "";
        }
        return this._querySuggester.spellCheckKeywords(searchContext);
    }

    @Override
    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) throws SearchException {
        if (this._querySuggester == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No query suggester configured");
            }
            return Collections.emptyMap();
        }
        return this._querySuggester.spellCheckKeywords(searchContext, max);
    }

    @Override
    public String[] suggestKeywordQueries(SearchContext searchContext, int max) throws SearchException {
        if (this._querySuggester == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No query suggester configured");
            }
            return StringPool.EMPTY_ARRAY;
        }
        return this._querySuggester.suggestKeywordQueries(searchContext, max);
    }
}

