/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ExceptionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokeredConnection
implements EngineConnection {
    int stateHoldability = 1;
    final BrokeredConnectionControl control;
    protected boolean isClosed;
    private String connString;
    private final ExceptionFactory exceptionFactory;
    private int stateIsolationLevel;
    private boolean stateReadOnly;
    private boolean stateAutoCommit;

    public BrokeredConnection(BrokeredConnectionControl brokeredConnectionControl) throws SQLException {
        this.control = brokeredConnectionControl;
        this.exceptionFactory = brokeredConnectionControl.getRealConnection().getExceptionFactory();
    }

    @Override
    public final void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.control.checkAutoCommit(bl);
            this.getRealConnection().setAutoCommit(bl);
            this.stateAutoCommit = bl;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final boolean getAutoCommit() throws SQLException {
        try {
            return this.getRealConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Statement createStatement() throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement());
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final CallableStatement prepareCall(String string) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(string), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final String nativeSQL(String string) throws SQLException {
        try {
            return this.getRealConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void commit() throws SQLException {
        try {
            this.control.checkCommit();
            this.getRealConnection().commit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void rollback() throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.control.checkClose();
            if (!this.control.closingConnection()) {
                this.isClosed = true;
                return;
            }
            this.isClosed = true;
            this.getRealConnection().close();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            boolean bl = this.getRealConnection().isClosed();
            if (bl) {
                this.control.closingConnection();
                this.isClosed = true;
            }
            return bl;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.getRealConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void clearWarnings() throws SQLException {
        try {
            this.getRealConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getRealConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getRealConnection().setReadOnly(bl);
            this.stateReadOnly = bl;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        try {
            return this.getRealConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void setCatalog(String string) throws SQLException {
        try {
            this.getRealConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final String getCatalog() throws SQLException {
        try {
            return this.getRealConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getRealConnection().setTransactionIsolation(n);
            this.stateIsolationLevel = n;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        try {
            return this.getRealConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Statement createStatement(int n, int n2) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n, n2), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(string, n, n2), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.getRealConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            n3 = this.statementHoldabilityCheck(n3);
            return this.control.wrapStatement(this.getRealConnection().createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            n3 = this.statementHoldabilityCheck(n3);
            return this.control.wrapStatement(this.getRealConnection().prepareCall(string, n, n2, n3), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Savepoint setSavepoint() throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Savepoint setSavepoint(String string) throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getRealConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final void setHoldability(int n) throws SQLException {
        try {
            n = this.control.checkHoldCursors(n, false);
            this.getRealConnection().setHoldability(n);
            this.stateHoldability = n;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n), string, n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, nArray), string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, stringArray), string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    final SQLException noCurrentConnection() {
        return this.exceptionFactory.getSQLException("08003", null, null, null);
    }

    final EngineConnection getRealConnection() throws SQLException {
        if (this.isClosed) {
            throw this.noCurrentConnection();
        }
        return this.control.getRealConnection();
    }

    final void notifyException(SQLException sQLException) {
        if (!this.isClosed) {
            this.control.notifyException(sQLException);
        }
    }

    public void syncState() throws SQLException {
        EngineConnection engineConnection = this.getRealConnection();
        this.stateIsolationLevel = engineConnection.getTransactionIsolation();
        this.stateReadOnly = engineConnection.isReadOnly();
        this.stateAutoCommit = engineConnection.getAutoCommit();
        this.stateHoldability = engineConnection.getHoldability();
    }

    public void getIsolationUptoDate() throws SQLException {
        if (this.control.isIsolationLevelSetUsingSQLorJDBC()) {
            this.stateIsolationLevel = this.getRealConnection().getTransactionIsolation();
            this.control.resetIsolationLevelFlag();
        }
    }

    public void setState(boolean bl) throws SQLException {
        if (bl) {
            EngineConnection engineConnection = this.getRealConnection();
            engineConnection.setTransactionIsolation(this.stateIsolationLevel);
            engineConnection.setReadOnly(this.stateReadOnly);
            engineConnection.setAutoCommit(this.stateAutoCommit);
            engineConnection.setHoldability(this.stateHoldability);
        }
    }

    public BrokeredStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        return new BrokeredStatement(brokeredStatementControl);
    }

    public BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string, Object object) throws SQLException {
        return new BrokeredPreparedStatement(brokeredStatementControl, string, object);
    }

    public BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string) throws SQLException {
        return new BrokeredCallableStatement(brokeredStatementControl, string);
    }

    @Override
    public final void setDrdaID(String string) {
        try {
            this.getRealConnection().setDrdaID(string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInGlobalTransaction() {
        return this.control.isInGlobalTransaction();
    }

    @Override
    public final void setPrepareIsolation(int n) throws SQLException {
        this.getRealConnection().setPrepareIsolation(n);
    }

    @Override
    public final int getPrepareIsolation() throws SQLException {
        return this.getRealConnection().getPrepareIsolation();
    }

    @Override
    public final void addWarning(SQLWarning sQLWarning) throws SQLException {
        this.getRealConnection().addWarning(sQLWarning);
    }

    public String toString() {
        if (this.connString == null) {
            String string;
            try {
                string = this.getRealConnection().toString();
            }
            catch (SQLException sQLException) {
                string = "<none>";
            }
            this.connString = this.getClass().getName() + "@" + this.hashCode() + ", Wrapped Connection = " + string;
        }
        return this.connString;
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            n3 = this.statementHoldabilityCheck(n3);
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n, n2, n3), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final int getHoldability() throws SQLException {
        try {
            return this.getRealConnection().getHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    final int statementHoldabilityCheck(int n) throws SQLException {
        int n2 = this.control.checkHoldCursors(n, true);
        if (n2 != n) {
            SQLWarning sQLWarning = SQLWarningFactory.newSQLWarning("01J07");
            this.addWarning(sQLWarning);
        }
        return n2;
    }

    @Override
    public void clearLOBMapping() throws SQLException {
        this.getRealConnection().clearLOBMapping();
    }

    @Override
    public Object getLOBMapping(int n) throws SQLException {
        return this.getRealConnection().getLOBMapping(n);
    }

    @Override
    public String getCurrentSchemaName() throws SQLException {
        try {
            return this.getRealConnection().getCurrentSchemaName();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void resetFromPool() throws SQLException {
        this.getRealConnection().resetFromPool();
    }

    @Override
    public final ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.getRealConnection().getSchema();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        try {
            this.getRealConnection().setSchema(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }
}

