/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.version.InternalVersion;

class VersionIteratorImpl
implements VersionIterator {
    private final LinkedList<NodeId> versions = new LinkedList();
    private int pos = 0;
    private final SessionImpl session;
    private final long size;

    public VersionIteratorImpl(Session session, InternalVersion rootVersion) {
        this(session, rootVersion, null);
    }

    public VersionIteratorImpl(Session session, InternalVersion rootVersion, InternalVersion baseVersion) {
        this.session = (SessionImpl)session;
        if (baseVersion == null) {
            this.collectAllVersions(rootVersion);
        } else {
            this.collectLinearVersions(baseVersion);
        }
        this.size = this.versions.size();
    }

    public Version nextVersion() {
        if (this.versions.isEmpty()) {
            throw new NoSuchElementException();
        }
        NodeId id = this.versions.removeFirst();
        ++this.pos;
        try {
            return (Version)this.session.getNodeById(id);
        }
        catch (RepositoryException e) {
            throw new ConcurrentModificationException("Unable to provide element: " + e.toString());
        }
    }

    public void skip(long skipNum) {
        while (skipNum > 0L) {
            --skipNum;
            this.nextVersion();
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getPosition() {
        return this.pos;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return !this.versions.isEmpty();
    }

    public Object next() {
        return this.nextVersion();
    }

    private synchronized void collectAllVersions(InternalVersion root) {
        LinkedList<InternalVersion> workQueue = new LinkedList<InternalVersion>();
        workQueue.add(root);
        while (!workQueue.isEmpty()) {
            InternalVersion currentVersion = (InternalVersion)workQueue.removeFirst();
            NodeId id = currentVersion.getId();
            if (this.versions.contains(id)) continue;
            this.versions.add(id);
            workQueue.addAll(currentVersion.getSuccessors());
        }
    }

    private synchronized void collectLinearVersions(InternalVersion base) {
        while (base != null) {
            this.versions.addFirst(base.getId());
            InternalVersion[] preds = base.getPredecessors();
            if (preds.length == 0) {
                base = null;
                continue;
            }
            base = preds[0];
        }
    }
}

