/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Core;

import JOscarLib.Core.OscarPacketAnalyser;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class OscarClient
implements Runnable {
    private OscarPacketAnalyser analyser;
    private String host;
    private int port;
    private Socket socketClient;
    private InputStream in;
    private DataOutputStream out;
    private Thread runner;
    private boolean running = true;

    public OscarClient(String host, int port, OscarPacketAnalyser analyser) {
        this.analyser = analyser;
        this.host = host;
        this.port = port;
        this.runner = new Thread((Runnable)this, "OscarClientThread");
    }

    public void connectToServer() {
        this.runner.start();
    }

    public synchronized void disconnect() throws IOException {
        this.running = false;
        this.socketClient.shutdownInput();
        this.socketClient.shutdownOutput();
    }

    public void run() {
        byte[] header = new byte[6];
        byte[] packet = null;
        int packetLen = 0;
        boolean waitData = false;
        try {
            this.socketClient = new Socket(this.host, this.port);
            this.out = new DataOutputStream(this.socketClient.getOutputStream());
            this.in = this.socketClient.getInputStream();
            while (this.running) {
                if (!waitData) {
                    if (this.in.available() >= 6) {
                        this.in.read(header, 0, 6);
                        packetLen = OscarClient.getPacketLen(header);
                        packet = new byte[packetLen + 6];
                        waitData = true;
                    }
                } else if (this.in.available() >= packetLen) {
                    this.in.read(packet, 6, packetLen);
                    System.arraycopy(header, 0, packet, 0, 6);
                    this.analyser.handlePacket(packet);
                    waitData = false;
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception E) {
            System.out.println("Client error : " + E.getMessage());
        }
    }

    public byte[] getInetaddress() {
        return this.socketClient.getLocalAddress().getAddress();
    }

    private static int getPacketLen(byte[] header) {
        int result = header[4] << 8 & 0xFF00;
        return result |= header[5] & 0xFF;
    }

    public void sendPacket(byte[] packet) {
        try {
            this.out.write(packet);
            this.out.flush();
        }
        catch (IOException IOE) {
            System.out.println(IOE.getMessage());
        }
    }
}

