/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;

public class NetChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(NetChecker.class);

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public boolean implies(Permission permission) {
        String name = permission.getName();
        if (name.equals("getProxySelector")) {
            if (!this.hasGetProxySelector(permission)) {
                this.logSecurityException(_log, "Attempted to get proxy selector");
                return false;
            }
        } else if (name.equals("specifyStreamHandler")) {
            if (!this.hasSpecifyStreamHandler(permission)) {
                this.logSecurityException(_log, "Attempted to specify stream handler");
                return false;
            }
        } else {
            this.logSecurityException(_log, "Attempted " + name + " network operation");
            return false;
        }
        return true;
    }

    protected boolean hasGetProxySelector(Permission permission) {
        int stackIndex = Reflection.getStackIndex(11, 10);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasSpecifyStreamHandler(Permission permission) {
        int stackIndex = Reflection.getStackIndex(11, 10);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }
}

