/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestProcMem
extends SigarTestCase {
    public TestProcMem(String name) {
        super(name);
    }

    private void traceMem(Sigar sigar, long pid) throws Exception {
        ProcMem procMem;
        try {
            procMem = sigar.getProcMem(pid);
        }
        catch (SigarException e) {
            this.traceln("pid " + pid + ": " + e.getMessage());
            return;
        }
        this.traceln("Pid=" + pid);
        this.traceln("Size=" + Sigar.formatSize(procMem.getSize()));
        this.traceln("Resident=" + Sigar.formatSize(procMem.getResident()));
        this.traceln("Share=" + Sigar.formatSize(procMem.getShare()));
        this.traceln("MinorFaults=" + procMem.getMinorFaults());
        this.traceln("MajorFaults=" + procMem.getMajorFaults());
        this.traceln("PageFaults=" + procMem.getPageFaults());
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        try {
            sigar.getProcMem(this.getInvalidPid());
        }
        catch (SigarException e) {
            // empty catch block
        }
        long[] pids = sigar.getProcList();
        for (int i = 0; i < pids.length; ++i) {
            this.traceMem(sigar, pids[i]);
        }
    }
}

