/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryTypePermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DLFileEntryTypeServiceImpl
extends DLFileEntryTypeServiceBaseImpl {
    public DLFileEntryType addFileEntryType(long groupId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        DLPermission.check(this.getPermissionChecker(), groupId, "ADD_DOCUMENT_TYPE");
        return this.dlFileEntryTypeLocalService.addFileEntryType(this.getUserId(), groupId, fileEntryTypeKey, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    public DLFileEntryType addFileEntryType(long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        return this.addFileEntryType(groupId, null, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException, SystemException {
        DLFileEntryTypePermission.check(this.getPermissionChecker(), fileEntryTypeId, "DELETE");
        this.dlFileEntryTypeLocalService.deleteFileEntryType(fileEntryTypeId);
    }

    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException, SystemException {
        DLFileEntryTypePermission.check(this.getPermissionChecker(), fileEntryTypeId, "VIEW");
        return this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) throws SystemException {
        return this.dlFileEntryTypePersistence.filterFindByGroupId(groupIds);
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds, int start, int end) throws SystemException {
        return this.dlFileEntryTypePersistence.filterFindByGroupId(groupIds, start, end);
    }

    public int getFileEntryTypesCount(long[] groupIds) throws SystemException {
        return this.dlFileEntryTypePersistence.filterCountByGroupId(groupIds);
    }

    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException, SystemException {
        return this.filterFileEntryTypes(this.dlFileEntryTypeLocalService.getFolderFileEntryTypes(groupIds, folderId, inherited));
    }

    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.dlFileEntryTypeFinder.filterFindByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) throws SystemException {
        return this.dlFileEntryTypeFinder.filterCountByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    public void updateFileEntryType(long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryTypePermission.check(this.getPermissionChecker(), fileEntryTypeId, "UPDATE");
        this.dlFileEntryTypeLocalService.updateFileEntryType(this.getUserId(), fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    public void updateFileEntryType(long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        this.updateFileEntryType(fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    protected List<DLFileEntryType> filterFileEntryTypes(List<DLFileEntryType> fileEntryTypes) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        fileEntryTypes = ListUtil.copy(fileEntryTypes);
        Iterator itr = fileEntryTypes.iterator();
        while (itr.hasNext()) {
            DLFileEntryType fileEntryType = (DLFileEntryType)itr.next();
            if (fileEntryType.getFileEntryTypeId() <= 0L || DLFileEntryTypePermission.contains(permissionChecker, fileEntryType, "VIEW")) continue;
            itr.remove();
        }
        return fileEntryTypes;
    }
}

