/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.dao.orm.hibernate.ExceptionTranslator;
import com.liferay.portal.dao.orm.hibernate.LockModeTranslator;
import com.liferay.portal.dao.orm.hibernate.QueryImpl;
import com.liferay.portal.dao.orm.hibernate.SQLQueryImpl;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import java.io.Serializable;
import java.sql.Connection;

@DoPrivileged
public class SessionImpl
implements Session {
    private org.hibernate.Session _session;

    public SessionImpl(org.hibernate.Session session) {
        this._session = session;
    }

    @NotPrivileged
    public void clear() throws ORMException {
        try {
            this._session.clear();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Connection close() throws ORMException {
        try {
            return this._session.close();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public boolean contains(Object object) throws ORMException {
        try {
            return this._session.contains(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Query createQuery(String queryString) throws ORMException {
        return this.createQuery(queryString, true);
    }

    public Query createQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJpqlToHql(queryString);
            return DoPrivilegedUtil.wrapWhenActive(new QueryImpl(this._session.createQuery(queryString), strictName));
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public SQLQuery createSQLQuery(String queryString) throws ORMException {
        return this.createSQLQuery(queryString, true);
    }

    public SQLQuery createSQLQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJpqlToHql(queryString);
            return DoPrivilegedUtil.wrapWhenActive(new SQLQueryImpl(this._session.createSQLQuery(queryString), strictName));
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public void delete(Object object) throws ORMException {
        try {
            this._session.delete(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public void evict(Object object) throws ORMException {
        try {
            this._session.evict(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public void flush() throws ORMException {
        try {
            this._session.flush();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Object get(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._session.get(clazz, id);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Object get(Class<?> clazz, Serializable id, LockMode lockMode) throws ORMException {
        try {
            return this._session.get(clazz, id, LockModeTranslator.translate(lockMode));
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Object getWrappedSession() {
        return this._session;
    }

    @NotPrivileged
    public Object load(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._session.load(clazz, id);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Object merge(Object object) throws ORMException {
        try {
            return this._session.merge(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public Serializable save(Object object) throws ORMException {
        try {
            return this._session.save(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    @NotPrivileged
    public void saveOrUpdate(Object object) throws ORMException {
        try {
            this._session.saveOrUpdate(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }
}

