/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.ClusterableInvokerUtil;
import com.liferay.portal.cluster.NullClusterable;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInvocation;

public class ClusterableAdvice
extends AnnotationChainableMethodAdvice<Clusterable> {
    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodInvocation);
        if (clusterable == NullClusterable.NULL_CLUSTERABLE) {
            return;
        }
        MethodHandler methodHandler = ClusterableInvokerUtil.createMethodHandler(clusterable.acceptor(), methodInvocation);
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)methodHandler, (boolean)true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return null;
        }
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodInvocation);
        if (clusterable == NullClusterable.NULL_CLUSTERABLE) {
            return null;
        }
        if (!clusterable.onMaster()) {
            return null;
        }
        Method method = methodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (ClusterMasterExecutorUtil.isMaster()) {
            Object result = methodInvocation.proceed();
            if (returnType == Void.TYPE) {
                result = this.nullResult;
            }
            return result;
        }
        MethodHandler methodHandler = ClusterableInvokerUtil.createMethodHandler(clusterable.acceptor(), methodInvocation);
        Future futureResult = ClusterMasterExecutorUtil.executeOnMaster((MethodHandler)methodHandler);
        Object result = futureResult.get(PropsValues.CLUSTERABLE_ADVICE_CALL_MASTER_TIMEOUT, TimeUnit.SECONDS);
        if (returnType == Void.TYPE) {
            result = this.nullResult;
        }
        return result;
    }

    @Override
    public Clusterable getNullAnnotation() {
        return NullClusterable.NULL_CLUSTERABLE;
    }
}

