/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongKeyLongValueHashMap;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.LobData;

public class SessionData {
    private final Database database;
    private final Session session;
    PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap resultMap;
    Object currentValue;
    HashMap sequenceMap;
    HashMap sequenceUpdateMap;
    LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();
    boolean hasLobOps;

    public SessionData(Database database, Session session) {
        this.database = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getSubqueryRowStore(TableBase table) {
        PersistentStore store = this.persistentStoreCollection.getStore(table);
        store.removeAll();
        return store;
    }

    public PersistentStore getNewResultRowStore(TableBase table, boolean isCached) {
        try {
            PersistentStore store = this.session.database.logger.newStore(this.session, this.persistentStoreCollection, table);
            if (!isCached) {
                store.setMemory(true);
            }
            return store;
        }
        catch (HsqlException hsqlException) {
            throw Error.runtimeError(201, "SessionData");
        }
    }

    void setResultSetProperties(Result command, Result result) {
        int required = command.rsProperties;
        int returned = result.rsProperties;
        if (required != returned) {
            if (ResultProperties.isReadOnly(required)) {
                returned = ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required));
            } else if (ResultProperties.isUpdatable(returned)) {
                if (ResultProperties.isHoldable(required)) {
                    this.session.addWarning(Error.error(4713));
                }
            } else {
                returned = ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required));
                this.session.addWarning(Error.error(4712));
            }
            if (ResultProperties.isSensitive(required)) {
                this.session.addWarning(Error.error(4711));
            }
            result.rsProperties = returned = ResultProperties.addScrollable(returned, ResultProperties.isScrollable(required));
        }
    }

    Result getDataResultHead(Result command, Result result, boolean isNetwork) {
        int fetchSize = command.getFetchSize();
        result.setResultId(this.session.actionTimestamp);
        int required = command.rsProperties;
        int returned = result.rsProperties;
        if (required != returned) {
            returned = ResultProperties.isReadOnly(required) ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : (ResultProperties.isReadOnly(returned) ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : (this.session.isAutoCommit() ? ResultProperties.addHoldable(returned, ResultProperties.isHoldable(required)) : ResultProperties.addHoldable(returned, false)));
            result.rsProperties = returned = ResultProperties.addScrollable(returned, ResultProperties.isScrollable(required));
        }
        boolean hold = false;
        boolean copy = false;
        if (ResultProperties.isUpdatable(result.rsProperties)) {
            hold = true;
        }
        if (isNetwork) {
            if (fetchSize != 0 && result.getNavigator().getSize() > fetchSize) {
                copy = true;
                hold = true;
            }
        } else if (!result.getNavigator().isMemory()) {
            hold = true;
        }
        if (hold) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result.getResultId(), result);
        }
        if (copy) {
            result = Result.newDataHeadResult(this.session, result, 0, fetchSize);
        }
        return result;
    }

    Result getDataResultSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return Result.newDataRowsResult(result, offset, count);
    }

    Result getDataResult(long id) {
        Result result = (Result)this.resultMap.get(id);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return new RowSetNavigatorClient(source, offset, count);
    }

    public void closeNavigator(long id) {
        Result result = (Result)this.resultMap.remove(id);
        result.getNavigator().close();
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            result.getNavigator().close();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            if (ResultProperties.isHoldable(result.rsProperties)) continue;
            result.getNavigator().close();
            it.remove();
        }
        this.resultMap.clear();
    }

    public void addToCreatedLobs(long lobID) {
        this.hasLobOps = true;
    }

    public void adjustLobUsageCount(Object value, int adjust) {
        if (this.session.isProcessingLog || this.session.isProcessingScript) {
            return;
        }
        if (value == null) {
            return;
        }
        this.database.lobManager.adjustUsageCount(this.session, ((LobData)value).getId(), adjust);
        this.hasLobOps = true;
    }

    public void adjustLobUsageCount(TableBase table, Object[] data, int adjust) {
        if (!table.hasLobColumn) {
            return;
        }
        if (table.isTemp) {
            return;
        }
        if (this.session.isProcessingLog || this.session.isProcessingScript) {
            return;
        }
        for (int j = 0; j < table.columnCount; ++j) {
            Object value;
            if (!table.colTypes[j].isLobType() || (value = data[j]) == null) continue;
            this.database.lobManager.adjustUsageCount(this.session, ((LobData)value).getId(), adjust);
            this.hasLobOps = true;
        }
    }

    public void allocateLobForResult(ResultLob result, InputStream inputStream) {
        try {
            switch (result.getSubType()) {
                case 7: {
                    long blobId;
                    long blobLength = result.getBlockLength();
                    if (blobLength < 0L) {
                        this.allocateBlobSegments(result, result.getInputStream());
                        break;
                    }
                    if (inputStream == null) {
                        blobId = result.getLobID();
                        inputStream = result.getInputStream();
                    } else {
                        BlobDataID blob = this.session.createBlob(blobLength);
                        blobId = blob.getId();
                        this.resultLobs.put(result.getLobID(), blobId);
                    }
                    CountdownInputStream countStream = new CountdownInputStream(inputStream);
                    countStream.setCount(blobLength);
                    this.database.lobManager.setBytesForNewBlob(blobId, countStream, result.getBlockLength());
                    break;
                }
                case 8: {
                    long clobId;
                    long clobLength = result.getBlockLength();
                    if (clobLength < 0L) {
                        this.allocateClobSegments(result, result.getReader());
                        break;
                    }
                    if (inputStream == null) {
                        clobId = result.getLobID();
                        inputStream = result.getReader() != null ? new ReaderInputStream(result.getReader()) : result.getInputStream();
                    } else {
                        ClobDataID clob = this.session.createClob(clobLength);
                        clobId = clob.getId();
                        this.resultLobs.put(result.getLobID(), clobId);
                    }
                    CountdownInputStream countStream = new CountdownInputStream(inputStream);
                    countStream.setCount(clobLength * 2L);
                    this.database.lobManager.setCharsForNewClob(clobId, countStream, result.getBlockLength(), false);
                    break;
                }
                case 2: {
                    long blobId = this.resultLobs.get(result.getLobID());
                    long blobLength = result.getBlockLength();
                    byte[] byteArray = result.getByteArray();
                    Result actionResult = this.database.lobManager.setBytes(blobId, result.getOffset(), byteArray);
                    break;
                }
                case 4: {
                    long clobId = this.resultLobs.get(result.getLobID());
                    long clobLength = result.getBlockLength();
                    char[] charArray = result.getCharArray();
                    Result actionResult = this.database.lobManager.setChars(clobId, result.getOffset(), charArray);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.resultLobs.clear();
            throw Error.error(458, e);
        }
    }

    private void allocateBlobSegments(ResultLob result, InputStream stream) throws IOException {
        long currentOffset = result.getOffset();
        int bufferLength = this.session.getStreamBlockSize();
        HsqlByteArrayOutputStream byteArrayOS = new HsqlByteArrayOutputStream(bufferLength);
        do {
            byteArrayOS.reset();
            byteArrayOS.write(stream, bufferLength);
            byte[] byteArray = byteArrayOS.getBuffer();
            if (byteArrayOS.size() < bufferLength) {
                byteArray = byteArrayOS.toByteArray();
            }
            Result actionResult = this.database.lobManager.setBytes(result.getLobID(), currentOffset, byteArray);
            currentOffset += (long)byteArrayOS.size();
        } while (byteArrayOS.size() >= bufferLength);
    }

    private void allocateClobSegments(ResultLob result, Reader reader) throws IOException {
        long currentOffset = result.getOffset();
        int bufferLength = this.session.getStreamBlockSize();
        CharArrayWriter charWriter = new CharArrayWriter(bufferLength);
        do {
            charWriter.reset();
            charWriter.write(reader, bufferLength);
            char[] charArray = charWriter.getBuffer();
            if (charWriter.size() < bufferLength) {
                charArray = charWriter.toCharArray();
            }
            Result actionResult = this.database.lobManager.setChars(result.getLobID(), currentOffset, charArray);
            currentOffset += (long)charWriter.size();
        } while (charWriter.size() >= bufferLength);
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator navigator = result.getNavigator();
        if (navigator == null) {
            this.registerLobsForRow((Object[])result.valueData);
        } else {
            while (navigator.next()) {
                Object[] data = navigator.getCurrent();
                this.registerLobsForRow(data);
            }
            navigator.reset();
        }
        this.resultLobs.clear();
    }

    private void registerLobsForRow(Object[] data) {
        for (int i = 0; i < data.length; ++i) {
            long id;
            if (data[i] instanceof BlobDataID) {
                BlobDataID blob = (BlobDataID)data[i];
                id = blob.getId();
                if (id < 0L) {
                    id = this.resultLobs.get(id);
                }
                data[i] = this.database.lobManager.getBlob(id);
                continue;
            }
            if (!(data[i] instanceof ClobDataID)) continue;
            ClobDataID clob = (ClobDataID)data[i];
            id = clob.getId();
            if (id < 0L) {
                id = this.resultLobs.get(id);
            }
            data[i] = this.database.lobManager.getClob(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ClobData createClobFromFile(String filename, String encoding) {
        ClobDataID clobDataID;
        File file = new File(filename);
        boolean exists = file.exists();
        if (!exists) {
            throw Error.error(452);
        }
        long fileLength = file.length();
        InputStream is = null;
        try {
            try {
                ClobDataID clob = this.session.createClob(fileLength);
                is = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader(is, encoding);
                is = new ReaderInputStream(reader);
                this.database.lobManager.setCharsForNewClob(clob.getId(), is, fileLength, true);
                clobDataID = clob;
                Object var12_11 = null;
            }
            catch (IOException e) {
                throw Error.error(452, e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return clobDataID;
        }
        is.close();
        return clobDataID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BlobData createBlobFromFile(String filename) {
        BlobDataID blobDataID;
        File file = new File(filename);
        boolean exists = file.exists();
        if (!exists) {
            throw Error.error(452);
        }
        long fileLength = file.length();
        InputStream is = null;
        try {
            try {
                BlobDataID blob = this.session.createBlob(fileLength);
                is = new FileInputStream(file);
                this.database.lobManager.setBytesForNewBlob(blob.getId(), is, fileLength);
                blobDataID = blob;
                Object var10_9 = null;
            }
            catch (IOException e) {
                throw Error.error(452);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return blobDataID;
        }
        is.close();
        return blobDataID;
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Object getSequenceValue(NumberSequence sequence) {
        HsqlNameManager.HsqlName key;
        Object value;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateMap = new HashMap();
        }
        if ((value = this.sequenceMap.get(key = sequence.getName())) == null) {
            value = sequence.getValueObject();
            this.sequenceMap.put(key, value);
            this.sequenceUpdateMap.put(sequence, value);
        }
        return value;
    }

    public Object getSequenceCurrent(NumberSequence sequence) {
        return this.sequenceUpdateMap == null ? null : this.sequenceUpdateMap.get(sequence);
    }
}

