/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.portal.kernel.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;

public class StringUtil
extends com.liferay.portal.kernel.util.StringUtil {
    public static String toLowerCase(String s) {
        return StringUtil.toLowerCase(s, null);
    }

    public static String toLowerCase(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (locale == null) {
                    locale = LocaleUtil.getDefault();
                }
                return s.toLowerCase(locale);
            }
            if (c >= 'A' && c <= 'Z') {
                if (sb == null) {
                    sb = new StringBuilder(s);
                }
                sb.setCharAt(i, (char)(c + 32));
            }
            ++i;
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String toUpperCase(String s) {
        return StringUtil.toUpperCase(s, null);
    }

    public static String toUpperCase(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (locale == null) {
                    locale = LocaleUtil.getDefault();
                }
                return s.toUpperCase(locale);
            }
            if (c >= 'a' && c <= 'z') {
                if (sb == null) {
                    sb = new StringBuilder(s);
                }
                sb.setCharAt(i, (char)(c - 32));
            }
            ++i;
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static boolean wildcardMatches(String s, String wildcard, char singleWildcardCharacter, char multipleWildcardCharacter, char escapeWildcardCharacter, boolean caseSensitive) {
        char c;
        int index;
        if (!caseSensitive) {
            s = StringUtil.toLowerCase(s);
            wildcard = StringUtil.toLowerCase(wildcard);
        }
        if ((index = wildcard.indexOf(escapeWildcardCharacter)) != -1) {
            char newSingleWildcardCharacter = '\u0000';
            while (wildcard.indexOf(newSingleWildcardCharacter) != -1) {
                newSingleWildcardCharacter = (char)(newSingleWildcardCharacter + 1);
            }
            char newMultipleWildcardCharacter = (char)(newSingleWildcardCharacter + 1);
            while (wildcard.indexOf(newMultipleWildcardCharacter) != -1) {
                newMultipleWildcardCharacter = (char)(newMultipleWildcardCharacter + '\u0001');
            }
            StringBuilder sb = new StringBuilder(wildcard);
            int i = 0;
            while (i < sb.length()) {
                c = sb.charAt(i);
                if (c == escapeWildcardCharacter) {
                    sb.deleteCharAt(i);
                } else if (c == singleWildcardCharacter) {
                    sb.setCharAt(i, newSingleWildcardCharacter);
                } else if (c == multipleWildcardCharacter) {
                    sb.setCharAt(i, newMultipleWildcardCharacter);
                }
                ++i;
            }
            wildcard = sb.toString();
            singleWildcardCharacter = newSingleWildcardCharacter;
            multipleWildcardCharacter = newMultipleWildcardCharacter;
        }
        index = 0;
        while (index < s.length()) {
            if (index >= wildcard.length()) {
                return false;
            }
            char c2 = wildcard.charAt(index);
            if (c2 == multipleWildcardCharacter) break;
            if (s.charAt(index) != c2 && c2 != singleWildcardCharacter) {
                return false;
            }
            ++index;
        }
        int sIndex = index;
        int wildcardIndex = index;
        int matchPoint = 0;
        int comparePoint = 0;
        while (sIndex < s.length()) {
            if (wildcardIndex == wildcard.length()) {
                return false;
            }
            c = wildcard.charAt(wildcardIndex);
            if (c == multipleWildcardCharacter) {
                if (++wildcardIndex == wildcard.length()) {
                    return true;
                }
                matchPoint = wildcardIndex;
                comparePoint = sIndex + 1;
                continue;
            }
            if (c == s.charAt(sIndex) || c == singleWildcardCharacter) {
                ++sIndex;
                ++wildcardIndex;
                continue;
            }
            wildcardIndex = matchPoint;
            sIndex = comparePoint++;
        }
        while (wildcardIndex < wildcard.length()) {
            if (wildcard.charAt(wildcardIndex) != multipleWildcardCharacter) break;
            ++wildcardIndex;
        }
        return wildcardIndex == wildcard.length();
    }
}

