/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.secureim;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.walluck.oscar.AIMSession;

public class SecureIM {
    private AIMSession sess;
    private String certificateFilename;
    private String certificatePassword;
    private Cipher decoder;
    private Cipher encoder;
    private byte[] encoded;

    public SecureIM(AIMSession sess, String certificateFilename, String certificatePassword) {
        this.sess = sess;
        this.certificateFilename = certificateFilename;
        this.certificatePassword = certificatePassword;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void init() throws IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, InvalidKeyException, NoSuchPaddingException {
        KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
        ks.load(new FileInputStream(this.certificateFilename), this.certificatePassword.toCharArray());
        String alias = ks.aliases().nextElement();
        X509Certificate c = (X509Certificate)ks.getCertificate(alias);
        this.encoded = c.getEncoded();
        RSAPublicKey rsapk = (RSAPublicKey)c.getPublicKey();
        this.decoder = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        this.encoder = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        this.decoder.init(2, rsapk);
    }

    public byte[] getEncoded() {
        return this.encoded;
    }
}

