/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthenticationManager;
import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.tags.WikiTagBase;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class UserProfileTag
extends WikiTagBase {
    private static final long serialVersionUID = 3258410625431582003L;
    public static final String BLANK = "(not set)";
    private static final String CREATED = "created";
    private static final String EMAIL = "email";
    private static final String EXISTS = "exists";
    private static final String NOT_EXISTS = "!exists";
    private static final String FULLNAME = "fullname";
    private static final String GROUPS = "groups";
    private static final String LOGINNAME = "loginname";
    private static final String MODIFIED = "modified";
    private static final String NEW = "new";
    private static final String NOT_NEW = "!new";
    private static final String ROLES = "roles";
    private static final String WIKINAME = "wikiname";
    private static final String CHANGE_LOGIN_NAME = "canchangeloginname";
    private static final String NOT_CHANGE_LOGIN_NAME = "!canchangeloginname";
    private static final String CHANGE_PASSWORD = "canchangepassword";
    private static final String NOT_CHANGE_PASSWORD = "!canchangepassword";
    private String m_prop;

    public void initTag() {
        super.initTag();
        this.m_prop = null;
    }

    public final int doWikiStartTag() throws IOException, WikiSecurityException {
        AuthenticationManager authMgr;
        UserManager manager = this.m_wikiContext.getEngine().getUserManager();
        UserProfile profile = manager.getUserProfile(this.m_wikiContext.getWikiSession());
        String result = null;
        if (EXISTS.equals(this.m_prop) || NOT_NEW.equals(this.m_prop)) {
            return profile.isNew() ? 0 : 1;
        }
        if (NEW.equals(this.m_prop) || NOT_EXISTS.equals(this.m_prop)) {
            return profile.isNew() ? 1 : 0;
        }
        if (CREATED.equals(this.m_prop) && profile.getCreated() != null) {
            result = profile.getCreated().toString();
        } else if (EMAIL.equals(this.m_prop)) {
            result = profile.getEmail();
        } else if (FULLNAME.equals(this.m_prop)) {
            result = profile.getFullname();
        } else if (GROUPS.equals(this.m_prop)) {
            result = UserProfileTag.printGroups(this.m_wikiContext);
        } else if (LOGINNAME.equals(this.m_prop)) {
            result = profile.getLoginName();
        } else if (MODIFIED.equals(this.m_prop) && profile.getLastModified() != null) {
            result = profile.getLastModified().toString();
        } else if (ROLES.equals(this.m_prop)) {
            result = UserProfileTag.printRoles(this.m_wikiContext);
        } else if (WIKINAME.equals(this.m_prop)) {
            WikiEngine engine;
            WikiSession wikiSession;
            Principal user;
            result = profile.getWikiName();
            if (result == null && (user = (wikiSession = WikiSession.getWikiSession(engine = this.m_wikiContext.getEngine(), (HttpServletRequest)this.pageContext.getRequest())).getUserPrincipal()) != null) {
                result = user.getName();
            }
        } else if (CHANGE_PASSWORD.equals(this.m_prop) || CHANGE_LOGIN_NAME.equals(this.m_prop) ? !(authMgr = this.m_wikiContext.getEngine().getAuthenticationManager()).isContainerAuthenticated() : (NOT_CHANGE_PASSWORD.equals(this.m_prop) || NOT_CHANGE_LOGIN_NAME.equals(this.m_prop)) && (authMgr = this.m_wikiContext.getEngine().getAuthenticationManager()).isContainerAuthenticated()) {
            return 1;
        }
        if (result != null) {
            this.pageContext.getOut().print(TextUtil.replaceEntities(result));
        }
        return 0;
    }

    public void setProperty(String property) {
        this.m_prop = property.toLowerCase().trim();
    }

    public static String printGroups(WikiContext context) {
        Principal[] roles = context.getWikiSession().getRoles();
        ArrayList<String> tempRoles = new ArrayList<String>();
        ResourceBundle rb = context.getBundle("CoreResources");
        for (Principal role : roles) {
            if (!(role instanceof GroupPrincipal)) continue;
            tempRoles.add(role.getName());
        }
        if (tempRoles.size() == 0) {
            return rb.getString("userprofile.nogroups");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tempRoles.size(); ++i) {
            String name = (String)tempRoles.get(i);
            sb.append(name);
            if (i >= tempRoles.size() - 1) continue;
            sb.append(',');
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String printRoles(WikiContext context) {
        Principal[] roles = context.getWikiSession().getRoles();
        ArrayList<String> tempRoles = new ArrayList<String>();
        ResourceBundle rb = context.getBundle("CoreResources");
        for (Principal role : roles) {
            if (!(role instanceof Role)) continue;
            tempRoles.add(role.getName());
        }
        if (tempRoles.size() == 0) {
            return rb.getString("userprofile.noroles");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tempRoles.size(); ++i) {
            String name = (String)tempRoles.get(i);
            sb.append(name);
            if (i >= tempRoles.size() - 1) continue;
            sb.append(',');
            sb.append(' ');
        }
        return sb.toString();
    }
}

