/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

final class LazyPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final boolean useNativePosix;
    private volatile POSIX posix;

    LazyPOSIX(POSIXHandler handler, boolean useNativePosix) {
        this.handler = handler;
        this.useNativePosix = useNativePosix;
    }

    private final POSIX posix() {
        return this.posix != null ? this.posix : this.loadPOSIX();
    }

    private final synchronized POSIX loadPOSIX() {
        return this.posix != null ? this.posix : (this.posix = POSIXFactory.loadPOSIX(this.handler, this.useNativePosix));
    }

    public FileStat allocateStat() {
        return this.posix().allocateStat();
    }

    public int chmod(String filename2, int mode2) {
        return this.posix().chmod(filename2, mode2);
    }

    public int chown(String filename2, int user, int group2) {
        return this.posix().chown(filename2, user, group2);
    }

    public int endgrent() {
        return this.posix().endgrent();
    }

    public int endpwent() {
        return this.posix().endpwent();
    }

    public int errno() {
        return this.posix().errno();
    }

    public void errno(int value2) {
        this.posix().errno(value2);
    }

    public int exec(String path2, String ... args2) {
        return this.posix().exec(path2, args2);
    }

    public int exec(String path2, String[] args2, String[] envp) {
        return this.posix().exec(path2, args2, envp);
    }

    public int execv(String path2, String[] argv) {
        return this.posix().execv(path2, argv);
    }

    public int execve(String path2, String[] argv, String[] envp) {
        return this.posix().execve(path2, argv, envp);
    }

    public int fork() {
        return this.posix().fork();
    }

    public FileStat fstat(FileDescriptor descriptor) {
        return this.posix().fstat(descriptor);
    }

    public int getegid() {
        return this.posix().getegid();
    }

    public int geteuid() {
        return this.posix().geteuid();
    }

    public int getgid() {
        return this.posix().getgid();
    }

    public Group getgrent() {
        return this.posix().getgrent();
    }

    public Group getgrgid(int which) {
        return this.posix().getgrgid(which);
    }

    public Group getgrnam(String which) {
        return this.posix().getgrnam(which);
    }

    public String getlogin() {
        return this.posix().getlogin();
    }

    public int getpgid() {
        return this.posix().getpgid();
    }

    public int getpgid(int pid2) {
        return this.posix().getpgid(pid2);
    }

    public int getpgrp() {
        return this.posix().getpgrp();
    }

    public int getpid() {
        return this.posix().getpid();
    }

    public int getppid() {
        return this.posix().getppid();
    }

    public int getpriority(int which, int who) {
        return this.posix().getpriority(which, who);
    }

    public Passwd getpwent() {
        return this.posix().getpwent();
    }

    public Passwd getpwnam(String which) {
        return this.posix().getpwnam(which);
    }

    public Passwd getpwuid(int which) {
        return this.posix().getpwuid(which);
    }

    public int getuid() {
        return this.posix().getuid();
    }

    public boolean isatty(FileDescriptor descriptor) {
        return this.posix().isatty(descriptor);
    }

    public int kill(int pid2, int signal2) {
        return this.posix().kill(pid2, signal2);
    }

    public int lchmod(String filename2, int mode2) {
        return this.posix().lchmod(filename2, mode2);
    }

    public int lchown(String filename2, int user, int group2) {
        return this.posix().lchown(filename2, user, group2);
    }

    public int link(String oldpath, String newpath) {
        return this.posix().link(oldpath, newpath);
    }

    public FileStat lstat(String path2) {
        return this.posix().lstat(path2);
    }

    public int mkdir(String path2, int mode2) {
        return this.posix().mkdir(path2, mode2);
    }

    public String readlink(String path2) throws IOException {
        return this.posix().readlink(path2);
    }

    public int setegid(int egid2) {
        return this.posix().setegid(egid2);
    }

    public int seteuid(int euid2) {
        return this.posix().seteuid(euid2);
    }

    public int setgid(int gid2) {
        return this.posix().setgid(gid2);
    }

    public int setgrent() {
        return this.posix().setgrent();
    }

    public int setpgid(int pid2, int pgid) {
        return this.posix().setpgid(pid2, pgid);
    }

    public int setpgrp(int pid2, int pgrp) {
        return this.posix().setpgrp(pid2, pgrp);
    }

    public int setpriority(int which, int who, int prio) {
        return this.posix().setpriority(which, who, prio);
    }

    public int setpwent() {
        return this.posix().setpwent();
    }

    public int setsid() {
        return this.posix().setsid();
    }

    public int setuid(int uid2) {
        return this.posix().setuid(uid2);
    }

    public FileStat stat(String path2) {
        return this.posix().stat(path2);
    }

    public int symlink(String oldpath, String newpath) {
        return this.posix().symlink(oldpath, newpath);
    }

    public int umask(int mask) {
        return this.posix().umask(mask);
    }

    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        return this.posix().utimes(path2, atimeval, mtimeval);
    }

    public int wait(int[] status2) {
        return this.posix().wait(status2);
    }

    public int waitpid(int pid2, int[] status2, int flags) {
        return this.posix().waitpid(pid2, status2, flags);
    }

    public boolean isNative() {
        return this.posix().isNative();
    }

    public LibC libc() {
        return this.posix().libc();
    }

    public String getenv(String envName) {
        return this.posix().getenv(envName);
    }

    public int setenv(String envName, String envValue, int overwrite) {
        return this.posix().setenv(envName, envValue, overwrite);
    }

    public int unsetenv(String envName) {
        return this.posix().unsetenv(envName);
    }
}

