/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.hot.DependencyManagementThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletContext;

public class HotDeployEvent {
    private static Log _log = LogFactoryUtil.getLog(HotDeployEvent.class);
    private ClassLoader _contextClassLoader;
    private Set<String> _dependentServletContextNames = new TreeSet<String>();
    private PluginPackage _pluginPackage;
    private Queue<PortalLifecycle> _portalLifecycles = new ConcurrentLinkedQueue<PortalLifecycle>();
    private ServletContext _servletContext;

    public HotDeployEvent(ServletContext servletContext, ClassLoader contextClassLoader) {
        this._servletContext = servletContext;
        this._contextClassLoader = contextClassLoader;
        try {
            this.initDependentServletContextNames();
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
        }
    }

    public void addPortalLifecycle(PortalLifecycle portalLifecycle) {
        this._portalLifecycles.add(portalLifecycle);
    }

    public void flushInits() {
        for (PortalLifecycle portalLifecycle : this._portalLifecycles) {
            portalLifecycle.portalInit();
        }
        this._portalLifecycles.clear();
    }

    public ClassLoader getContextClassLoader() {
        return this._contextClassLoader;
    }

    public Set<String> getDependentServletContextNames() {
        return this._dependentServletContextNames;
    }

    public PluginPackage getPluginPackage() {
        return this._pluginPackage;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public String getServletContextName() {
        return this._servletContext.getServletContextName();
    }

    public void setPluginPackage(PluginPackage pluginPackage) {
        this._pluginPackage = pluginPackage;
    }

    protected void initDependentServletContextNames() throws IOException {
        if (!DependencyManagementThreadLocal.isEnabled().booleanValue()) {
            return;
        }
        List<String[]> levelsRequiredDeploymentContexts = DeployManagerUtil.getLevelsRequiredDeploymentContexts();
        for (Object[] objectArray : levelsRequiredDeploymentContexts) {
            if (ArrayUtil.contains(objectArray, this._servletContext.getServletContextName())) break;
            Object[] n3 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object levelRequiredDeploymentContext = n3[n2];
                this._dependentServletContextNames.add((String)levelRequiredDeploymentContext);
                ++n2;
            }
        }
        InputStream inputStream = this._servletContext.getResourceAsStream("/WEB-INF/liferay-plugin-package.properties");
        if (inputStream != null) {
            String[] pluginPackgeRequiredDeploymentContexts;
            String propertiesString = StringUtil.read(inputStream);
            Properties properties = PropertiesUtil.load(propertiesString);
            String[] stringArray = pluginPackgeRequiredDeploymentContexts = StringUtil.split(properties.getProperty("required-deployment-contexts"));
            int n = pluginPackgeRequiredDeploymentContexts.length;
            int n3 = 0;
            while (n3 < n) {
                String pluginPackageRequiredDeploymentContext = stringArray[n3];
                this._dependentServletContextNames.add(pluginPackageRequiredDeploymentContext.trim());
                ++n3;
            }
        }
        if (!this._dependentServletContextNames.isEmpty() && _log.isInfoEnabled()) {
            String servletContextName = this._servletContext.getServletContextName();
            _log.info("Plugin " + servletContextName + " requires " + StringUtil.merge(this._dependentServletContextNames, ", "));
        }
    }
}

