/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.aggregate.AggregateContext;
import java.util.LinkedList;

public abstract class BaseAggregateContext
implements AggregateContext {
    private LinkedList<String> _list = new LinkedList();

    @Override
    public String getFullPath(String path) {
        String listPath = this._generatePathFromList();
        return listPath.concat(path);
    }

    @Override
    public String getResourcePath(String path) {
        return this.getFullPath(path);
    }

    @Override
    public String popPath() {
        if (this._list.isEmpty()) {
            return null;
        }
        return this._list.pop();
    }

    @Override
    public void pushPath(String path) {
        if (Validator.isNotNull((String)path)) {
            this._list.push(path);
        }
    }

    @Override
    public String shiftPath() {
        if (this._list.isEmpty()) {
            return null;
        }
        return this._list.removeLast();
    }

    @Override
    public void unshiftPath(String path) {
        if (Validator.isNotNull((String)path)) {
            this._list.addLast(path);
        }
    }

    private String _generatePathFromList() {
        StringBundler sb = new StringBundler(this._list.size());
        int i2 = this._list.size() - 1;
        while (i2 >= 0) {
            String path = this._list.get(i2);
            sb.append(path);
            if (!path.endsWith("/")) {
                sb.append("/");
            }
            --i2;
        }
        return StringUtil.replace((String)sb.toString(), (String)"//", (String)"/");
    }
}

