/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.persistence.LayoutSetPrototypeUtil;
import java.util.Date;

public class LayoutSetPrototypeLayoutListener
extends BaseModelListener<Layout> {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutListener.class);

    public void onAfterCreate(Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    public void onAfterRemove(Layout layout) {
        this.updateLayoutSetPrototype(layout, new Date());
    }

    public void onAfterUpdate(Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(Layout layout, Date modifiedDate) {
        try {
            Group group = layout.getGroup();
            if (!group.isLayoutSetPrototype()) {
                return;
            }
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            layoutSetPrototype.setModifiedDate(modifiedDate);
            LayoutSetPrototypeUtil.update((LayoutSetPrototype)layoutSetPrototype);
            LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
            layoutSet.setModifiedDate(layout.getModifiedDate());
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            settingsProperties.remove((Object)"merge-fail-count");
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

