/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.liveusers.messaging;

import com.liferay.portal.kernel.cluster.BaseClusterResponseCallback;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.liveusers.LiveUsers;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LiveUsersMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(LiveUsersMessageListener.class);
    private static MethodHandler _getLocalClusterUsersMethodHandler = new MethodHandler(new MethodKey(LiveUsers.class, "getLocalClusterUsers", new Class[0]), new Object[0]);

    protected void doCommandAddClusterNode(JSONObject jsonObject) throws Exception {
        String clusterNodeId = jsonObject.getString("clusterNodeId");
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)_getLocalClusterUsersMethodHandler, (String[])new String[]{clusterNodeId});
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest, (ClusterResponseCallback)new LiveUsersClusterResponseCallback(clusterNodeId), (long)20000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected void doCommandRemoveClusterNode(JSONObject jsonObject) throws Exception {
        String clusterNodeId = jsonObject.getString("clusterNodeId");
        LiveUsers.removeClusterNode(clusterNodeId);
    }

    protected void doCommandSignIn(JSONObject jsonObject) throws Exception {
        String clusterNodeId = jsonObject.getString("clusterNodeId");
        long companyId = jsonObject.getLong("companyId");
        long userId = jsonObject.getLong("userId");
        String sessionId = jsonObject.getString("sessionId");
        String remoteAddr = jsonObject.getString("remoteAddr");
        String remoteHost = jsonObject.getString("remoteHost");
        String userAgent = jsonObject.getString("userAgent");
        LiveUsers.signIn(clusterNodeId, companyId, userId, sessionId, remoteAddr, remoteHost, userAgent);
    }

    protected void doCommandSignOut(JSONObject jsonObject) throws Exception {
        String clusterNodeId = jsonObject.getString("clusterNodeId");
        long companyId = jsonObject.getLong("companyId");
        long userId = jsonObject.getLong("userId");
        String sessionId = jsonObject.getString("sessionId");
        LiveUsers.signOut(clusterNodeId, companyId, userId, sessionId);
    }

    protected void doReceive(Message message) throws Exception {
        String payload = (String)message.getPayload();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)payload);
        String command = jsonObject.getString("command");
        if (command.equals("addClusterNode")) {
            this.doCommandAddClusterNode(jsonObject);
        } else if (command.equals("removeClusterNode")) {
            this.doCommandRemoveClusterNode(jsonObject);
        } else if (command.equals("signIn")) {
            this.doCommandSignIn(jsonObject);
        } else if (command.equals("signOut")) {
            this.doCommandSignOut(jsonObject);
        }
    }

    private class LiveUsersClusterResponseCallback
    extends BaseClusterResponseCallback {
        private String _clusterNodeId;

        public LiveUsersClusterResponseCallback(String clusterNodeId) {
            this._clusterNodeId = clusterNodeId;
        }

        public void callback(ClusterNodeResponses clusterNodeResponses) {
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(this._clusterNodeId);
            try {
                Object result = clusterNodeResponse.getResult();
                if (result == null) {
                    return;
                }
                Map clusterUsers = (Map)result;
                LiveUsers.addClusterNode(this._clusterNodeId, clusterUsers);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to add cluster node " + this._clusterNodeId), (Throwable)e2);
            }
        }

        public void processTimeoutException(TimeoutException timeoutException) {
            _log.error((Object)("Uanble to add cluster node " + this._clusterNodeId), (Throwable)timeoutException);
        }
    }
}

