/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.operation.Copy;
import org.gcube.contentmanagement.blobstorage.service.operation.CopyDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.DuplicateFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Link;
import org.gcube.contentmanagement.blobstorage.service.operation.Lock;
import org.gcube.contentmanagement.blobstorage.service.operation.Move;
import org.gcube.contentmanagement.blobstorage.service.operation.MoveDir;
import org.gcube.contentmanagement.blobstorage.service.operation.SoftCopy;
import org.gcube.contentmanagement.blobstorage.service.operation.Unlock;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoOperationManager
extends TransportManager {
    final Logger logger = LoggerFactory.getLogger(MongoOperationManager.class);
    private MongoIOManager mongoPrimaryInstance;
    private MongoIOManager mongoSecondaryInstance;
    private MemoryType memoryType;
    protected static String[] dbNames;

    public MongoOperationManager(String[] server, String user, String password, MemoryType memoryType, String[] dbNames, String writeConcern, String readConcern) {
        this.initBackend(server, user, password, memoryType, dbNames, writeConcern, readConcern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initBackend(String[] server, String user, String pass, MemoryType memoryType, String[] dbNames, String writeConcern, String readConcern) {
        try {
            this.memoryType = memoryType;
            MongoOperationManager.dbNames = dbNames;
            this.logger.debug("check mongo configuration");
            if (dbNames != null) {
                if (dbNames.length == 1) {
                    this.logger.info("found one mongo db to connect");
                    this.mongoPrimaryInstance = this.getMongoInstance(server, user, pass, memoryType, dbNames[0], writeConcern, readConcern);
                    return;
                } else if (dbNames.length == 0) {
                    this.logger.warn("primary db not discovered correctly. Backend will be instantiated with default value");
                    this.mongoPrimaryInstance = this.getMongoInstance(server, user, pass, memoryType, null, writeConcern, readConcern);
                    return;
                } else {
                    if (dbNames.length != 2) throw new RuntimeException("Found more than 2 collection on the ServiceEndopint. This case is not managed");
                    this.logger.info("found two mongo db to connect");
                    this.mongoPrimaryInstance = this.getMongoInstance(server, user, pass, memoryType, dbNames[0], writeConcern, readConcern);
                    this.mongoSecondaryInstance = this.getMongoInstance(server, user, pass, memoryType, dbNames[1], writeConcern, readConcern);
                }
                return;
            } else {
                this.logger.debug("primary db not discovered. Backend will be instantiated with default value");
                this.mongoPrimaryInstance = this.getMongoInstance(server, user, pass, memoryType, null, writeConcern, readConcern);
            }
            return;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return;
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    private MongoIOManager getMongoInstance(String[] server, String user, String password, MemoryType memoryType, String dbName, String writeConcern, String readPreference) throws UnknownHostException {
        MongoIOManager mongoInstance = new MongoIOManager(server, user, password, memoryType, dbName, writeConcern, readPreference);
        mongoInstance.clean();
        DBCollection coll = mongoInstance.getMetaDataCollection();
        coll.createIndex((DBObject)new BasicDBObject("filename", (Object)1));
        coll.createIndex((DBObject)new BasicDBObject("dir", (Object)1));
        coll.createIndex((DBObject)new BasicDBObject("owner", (Object)1));
        return mongoInstance;
    }

    public ObjectId get(Download download) throws IOException {
        return download.execute(this.mongoPrimaryInstance, this.mongoSecondaryInstance);
    }

    @Override
    public String lock(Lock lock) throws Exception {
        return lock.execute(this.mongoPrimaryInstance, this.mongoSecondaryInstance, lock.getResource(), lock.getBucket());
    }

    @Override
    public String put(Upload upload) throws IOException {
        return upload.execute(this.mongoPrimaryInstance, this.mongoSecondaryInstance, upload.getResource(), upload.getBucket(), upload.isReplaceOption());
    }

    @Override
    public void close() {
        this.mongoPrimaryInstance.close();
    }

    @Override
    public String unlock(Unlock unlock) throws Exception {
        return unlock.execute(this.mongoPrimaryInstance, this.mongoSecondaryInstance, unlock.getResource(), unlock.getBucket(), unlock.getKeyUnlock());
    }

    @Override
    public Map<String, StorageObject> getValues(MyFile resource, String bucket, Class<? extends Object> type) {
        HashMap<String, StorageObject> map = null;
        try {
            OperationDefinition op = resource.getOperationDefinition();
            this.logger.info("MongoClient getValues method: " + op.toString());
            GridFS gfs = this.mongoPrimaryInstance.getGfs(MongoOperationManager.getPrimaryCollectionName(), true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mongo get values of dir: " + bucket);
            }
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"dir", (Object)bucket);
            List<GridFSDBFile> list = gfs.find((DBObject)query);
            list = this.mongoPrimaryInstance.patchRemoteDirPathVersion1(bucket, gfs, query, list);
            this.logger.info("find all object (files/dirs) in the directory " + bucket);
            for (GridFSDBFile f : list) {
                if (map == null) {
                    map = new HashMap<String, StorageObject>();
                }
                StorageObject s_obj = null;
                if (f.get("type") == null || f.get("type").toString().equalsIgnoreCase("file")) {
                    String creationTime;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("found object: " + f.get("name") + "    type:  " + f.get("type"));
                    }
                    s_obj = new StorageObject(f.get("name").toString(), "file");
                    String owner = (String)f.get("owner");
                    if (owner != null) {
                        s_obj.setOwner(owner);
                    }
                    if ((creationTime = (String)f.get("creationTime")) != null) {
                        s_obj.setCreationTime(creationTime);
                    }
                    s_obj.setId(f.getId().toString());
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("found directory: " + f.get("name") + "    type:  " + f.get("type"));
                    }
                    BasicDBObject queryDir = new BasicDBObject();
                    queryDir.put((Object)"dir", (Object)(f.get("dir").toString() + f.get("name").toString()));
                    List listDir = gfs.find((DBObject)queryDir);
                    if (listDir != null && listDir.size() > 0) {
                        s_obj = new StorageObject(f.get("name").toString(), "dir");
                    } else {
                        BasicDBObject queryFile = new BasicDBObject();
                        queryFile.put((Object)"filename", (Object)Pattern.compile(f.get("dir").toString() + "*"));
                        this.logger.info("find all files in the directory " + f.get("name"));
                        List listFile = gfs.find((DBObject)queryFile);
                        this.logger.info("search completed");
                        s_obj = listFile != null && listFile.size() > 0 ? new StorageObject(f.get("name").toString(), "dir") : null;
                    }
                }
                if (s_obj == null) continue;
                map.put(f.get("name").toString(), s_obj);
            }
            this.logger.info("search completed");
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException("problem to retrieve objects in the folder: " + bucket + " exception message: " + e.getMessage());
        }
        this.close();
        return map;
    }

    @Override
    public void removeRemoteFile(String bucket, MyFile resource) throws UnknownHostException {
        this.logger.info("Check file: " + bucket + " for removing operation");
        GridFSDBFile f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(bucket, null, true);
        if (f != null) {
            this.mongoPrimaryInstance.checkAndRemove(f, resource);
        } else {
            ObjectId id;
            GridFSDBFile fID;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File Not Found. Try to delete by ObjectID");
            }
            if (bucket.length() > 23 && (fID = this.mongoPrimaryInstance.findGFSCollectionObject(id = new ObjectId(bucket))) != null) {
                this.mongoPrimaryInstance.checkAndRemove(fID, resource);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("object deleted by ID");
                }
            }
        }
        this.close();
    }

    @Override
    public void removeDir(String remoteDir, MyFile resource) {
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(remoteDir);
        this.patchCompatibilityOldLibraryVersion(remoteDir, dirs);
        GridFS gfs = this.mongoPrimaryInstance.getGfs(MongoOperationManager.getPrimaryCollectionName(), true);
        for (String directory : dirs) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mongo start operation delete bucket: " + directory);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("remove subfolders of folder: " + directory);
            }
            BasicDBObject query = new BasicDBObject();
            String regex = directory + "*";
            query.put((Object)"dir", (Object)Pattern.compile(regex));
            this.mongoPrimaryInstance.removeObject(gfs, query, resource);
            query = new BasicDBObject();
            String[] dir = directory.split("/");
            StringBuffer parentDir = new StringBuffer();
            for (int i = 0; i < dir.length - 1; ++i) {
                parentDir.append(dir[i] + "/");
            }
            String name = dir[dir.length - 1];
            query.put((Object)"dir", (Object)parentDir.toString());
            query.put((Object)"name", (Object)name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("now remove the folder: " + name + " from folder " + parentDir);
            }
            this.mongoPrimaryInstance.removeObject(gfs, query, resource);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Mongo end operation delete bucket: " + directory);
        }
        this.close();
    }

    private void patchCompatibilityOldLibraryVersion(String remoteDir, ArrayList<String> dirs) {
        if (remoteDir.contains("/home/null/") || remoteDir.contains("/public/")) {
            if (remoteDir.contains("/home/null/")) {
                String remoteDirV1 = remoteDir.replace("/home/null/", "/public/");
                dirs.add(remoteDirV1);
            } else {
                String remoteDirV2 = remoteDir.replace("/public/", "/home/null/");
                dirs.add(remoteDirV2);
                String remoteDirV2patch = "/" + remoteDirV2;
                dirs.add(remoteDirV2patch);
            }
        }
    }

    @Override
    public long getSize(String remotePath) {
        GridFSDBFile f;
        long length = -1L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - get Size for pathServer: " + remotePath);
        }
        if ((f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(remotePath, null, true)) != null) {
            length = f.getLength();
        }
        this.close();
        return length;
    }

    @Override
    public boolean exist(String remotePath) {
        GridFSDBFile f;
        boolean isPresent = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - get Size for pathServer: " + remotePath);
        }
        if ((f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(remotePath, null, true)) != null) {
            isPresent = true;
        }
        this.close();
        return isPresent;
    }

    @Override
    public long getTTL(String remotePath) throws UnknownHostException {
        GridFSDBFile f;
        long timestamp = -1L;
        long currentTTL = -1L;
        long remainsTTL = -1L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(remotePath, null, true)) != null && (timestamp = ((Long)f.get("timestamp")).longValue()) > 0L) {
            currentTTL = System.currentTimeMillis() - timestamp;
            remainsTTL = 180000L - currentTTL;
        }
        this.close();
        return remainsTTL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long renewTTL(MyFile resource) throws UnknownHostException, IllegalAccessException {
        String lock;
        long ttl = -1L;
        MyFile file = resource;
        OperationDefinition.REMOTE_RESOURCE remoteResourceIdentifier = file.getOperation().getRemoteResource();
        String key = file.getLockedKey();
        String remotePath = file.getRemotePath();
        GridFSDBFile f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(remotePath, remoteResourceIdentifier, true);
        if (f != null && (lock = (String)f.get("lock")) != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (!lck.equalsIgnoreCase(key)) {
                this.close();
                throw new IllegalAccessError("bad key for unlock");
            }
            if (f.containsField("countRenew") && f.get("countRenew") != null) {
                int count = (Integer)f.get("countRenew");
                if (count >= 5) {
                    this.close();
                    throw new IllegalAccessException("The number max of TTL renew reached. The number max is: 5");
                }
                f.put("countRenew", (Object)(count + 1));
            } else {
                f.put("countRenew", (Object)1);
            }
            f.put("timestamp", (Object)System.currentTimeMillis());
            f.save();
            ttl = 180000L;
        }
        this.close();
        return ttl;
    }

    @Override
    public String link(Link link) throws UnknownHostException {
        return link.execute(this.mongoPrimaryInstance, this.mongoSecondaryInstance, link.getResource(), link.getSourcePath(), link.getDestinationPath());
    }

    @Override
    public String copy(Copy copy) throws UnknownHostException {
        this.logger.info("CopyFile operation from " + copy.getSourcePath() + " to " + copy.getDestinationPath());
        return copy.execute(this.mongoPrimaryInstance, copy.getResource(), copy.getSourcePath(), copy.getDestinationPath());
    }

    @Override
    public String move(Move move) throws UnknownHostException {
        this.logger.info("MoveFile operation from " + move.getSourcePath() + " to " + move.getDestinationPath());
        return move.execute(this.mongoPrimaryInstance, this.memoryType, move.getResource(), move.getSourcePath(), move.getDestinationPath());
    }

    @Override
    public String getName() {
        return "MongoDB";
    }

    @Override
    public List<String> copyDir(CopyDir copy) throws UnknownHostException {
        return copy.execute(this.mongoPrimaryInstance, copy.getResource(), copy.getSourcePath(), copy.getDestinationPath());
    }

    @Override
    public List<String> moveDir(MoveDir move) throws UnknownHostException {
        return move.execute(this.mongoPrimaryInstance, move.getResource(), move.getSourcePath(), move.getDestinationPath(), this.memoryType);
    }

    @Override
    public String getFileProperty(String remotePath, String property) {
        GridFSDBFile f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(remotePath, null, true);
        if (f != null) {
            String value = (String)f.get(property);
            this.close();
            return value;
        }
        this.close();
        throw new RemoteBackendException("remote file not found at path: " + remotePath);
    }

    @Override
    public void setFileProperty(String remotePath, String propertyField, String propertyValue) {
        this.logger.trace("setting field " + propertyField + " with value: " + propertyValue);
        try {
            this.updateMetaObject(remotePath, propertyField, propertyValue);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new RemoteBackendException("UnknownHostException:  " + e.getMessage());
        }
    }

    private void updateMetaObject(String remoteIdentifier, String propertyField, String propertyValue) throws UnknownHostException {
        this.logger.debug("find object...");
        BasicDBObject remoteMetaCollectionObject = this.mongoPrimaryInstance.findMetaCollectionObject(remoteIdentifier);
        if (remoteMetaCollectionObject != null) {
            this.logger.debug("object found");
            remoteMetaCollectionObject.put((Object)propertyField, (Object)propertyValue);
            this.logger.info("set query field: " + propertyField + " with value: " + propertyValue);
            BasicDBObject updateQuery = new BasicDBObject();
            updateQuery.put((Object)"$set", (Object)remoteMetaCollectionObject);
            BasicDBObject querySourceObject = this.getQuery(remoteIdentifier);
            this.logger.debug("get Collection ");
            DBCollection metaCollectionInstance = this.mongoPrimaryInstance.getMetaDataCollection(this.mongoPrimaryInstance.getConnectionDB(MongoOperationManager.getPrimaryCollectionName(), false));
            this.logger.debug("update Collection ");
            if (this.memoryType != MemoryType.VOLATILE) {
                metaCollectionInstance.update((DBObject)querySourceObject, (DBObject)updateQuery, false, true, MongoIOManager.DEFAULT_WRITE_TYPE);
            } else {
                metaCollectionInstance.update((DBObject)querySourceObject, (DBObject)updateQuery, false, true);
            }
        } else {
            this.logger.debug("object not found");
            this.close();
            throw new RemoteBackendException("remote file not found at path: " + remoteIdentifier);
        }
        this.logger.info("update completed");
        this.close();
    }

    private BasicDBObject getQuery(String remoteIdentifier) {
        BasicDBObject querySourceObject = new BasicDBObject();
        this.logger.debug("check identifier object: " + remoteIdentifier);
        if (ObjectId.isValid((String)remoteIdentifier)) {
            this.logger.debug("object is a valid id");
            querySourceObject.put((Object)"_id", (Object)new ObjectId(remoteIdentifier));
        } else {
            this.logger.debug("object is a remotepath");
            querySourceObject.put((Object)"filename", (Object)remoteIdentifier);
        }
        return querySourceObject;
    }

    @Override
    public long getFolderTotalItems(String folderPath) {
        this.logger.debug("getFolderTotalItems for folder " + folderPath);
        long totalItems = 0L;
        try {
            List<GridFSDBFile> list = this.mongoPrimaryInstance.getFilesOnFolder(folderPath);
            totalItems = this.getCount(list);
            this.logger.info("getFolderTotalItems found " + list.size() + " objects for folder " + folderPath);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return totalItems;
    }

    @Override
    public long getFolderTotalVolume(String folderPath) {
        this.logger.debug("getFolderTotalVolume for folder " + folderPath);
        long totalVolume = 0L;
        try {
            List<GridFSDBFile> list = this.mongoPrimaryInstance.getFilesOnFolder(folderPath);
            totalVolume = this.getVolume(list);
            this.logger.info("getFolderTotalVolume  " + totalVolume + " for folder " + folderPath);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return totalVolume;
    }

    @Override
    public String getUserTotalVolume(String user) {
        this.logger.debug("getUserTotalVolume for folder " + user);
        long volume = 0L;
        try {
            List<GridFSDBFile> list = this.mongoPrimaryInstance.getOwnedFiles(user);
            volume = this.getVolume(list);
            this.logger.info("getUserTotalVolume found " + volume + " for user " + user);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return "" + volume;
    }

    @Override
    public String getUserTotalItems(String user) {
        this.logger.debug("getUserTotalItems for folder " + user);
        long count = 0L;
        try {
            List<GridFSDBFile> list = this.mongoPrimaryInstance.getOwnedFiles(user);
            this.logger.info("getUserTotalItems found " + list.size() + " objects for user " + user);
            count = this.getCount(list);
        }
        catch (Exception e) {
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return "" + count;
    }

    @Override
    public String getId(String path, boolean forceCreation) {
        GridFSDBFile f;
        ObjectId id = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + path);
        }
        if ((f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(path, null, true)) != null) {
            id = (ObjectId)f.getId();
        } else if (forceCreation) {
            this.logger.warn("The remote file doesn't exist. An empty file will be created");
            id = this.forceCreation(path, id);
        } else {
            this.close();
            throw new RemoteBackendException("the file " + path + " is not present on storage. The uri is not created ");
        }
        this.close();
        return id.toString();
    }

    private long getCount(List<GridFSDBFile> list) {
        return list.size();
    }

    private long getVolume(List<GridFSDBFile> list) {
        long partialVolume = 0L;
        for (GridFSDBFile f : list) {
            long fileVolume = f.getLength();
            partialVolume += fileVolume;
        }
        return partialVolume;
    }

    private ObjectId forceCreation(String path, ObjectId id) {
        if (ObjectId.isValid((String)path)) {
            this.logger.error("Cannot force creation of smp uri without a remote path. The input parameter is not a remotePath valid: " + path);
            this.close();
            throw new RemoteBackendException("The uri is not created. Cannot force creation of smp uri without a remote path. The input parameter is not a remotePath:  " + path);
        }
        byte[] data = new byte[1];
        GridFSInputFile f2 = null;
        f2 = path.startsWith("/VOLATILE") ? this.mongoPrimaryInstance.createGFSFileObject(data) : this.mongoPrimaryInstance.createGFSFileObject(data, null, null);
        int indexName = path.lastIndexOf("/");
        String name = path.substring(indexName + 1);
        String dir = path.substring(0, indexName + 1);
        f2.put("filename", (Object)path);
        f2.put("name", (Object)name);
        f2.put("dir", (Object)dir);
        id = (ObjectId)f2.getId();
        f2.save();
        this.close();
        return id;
    }

    @Override
    public boolean isValidId(String id) {
        return ObjectId.isValid((String)id);
    }

    @Override
    public String getRemotePath(String bucket) throws UnknownHostException {
        if (!ObjectId.isValid((String)bucket)) {
            throw new RuntimeException("The following id is not valid: " + bucket);
        }
        String path = null;
        path = this.getField(bucket, "filename");
        return path;
    }

    @Override
    public String getField(String remoteIdentifier, String fieldName) throws UnknownHostException {
        GridFSDBFile f;
        String fieldValue = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remoteIdentifier);
        }
        if ((f = this.mongoPrimaryInstance.retrieveRemoteDescriptor(remoteIdentifier, null, true)) != null) {
            fieldValue = f.get(fieldName).toString();
        }
        this.close();
        return fieldValue;
    }

    public static String getPrimaryCollectionName() {
        if (dbNames != null && dbNames.length > 0) {
            return dbNames[0];
        }
        return null;
    }

    protected static String getSecondaryCollectionName() {
        if (dbNames != null && dbNames.length > 1) {
            return dbNames[1];
        }
        return null;
    }

    @Override
    public String duplicateFile(DuplicateFile duplicate) {
        return duplicate.execute(this.mongoPrimaryInstance);
    }

    @Override
    public String softCopy(SoftCopy copy) throws UnknownHostException {
        return copy.execute(this.mongoPrimaryInstance, copy.getResource(), copy.getSourcePath(), copy.getDestinationPath());
    }
}

