/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collections;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NodeResolver {
    private final Session session;
    private final NamePathResolver resolver;
    private String userSearchRoot = "/rep:security/rep:authorizables/rep:users";
    private String groupSearchRoot = "/rep:security/rep:authorizables/rep:groups";
    private String authorizableSearchRoot = "/rep:security/rep:authorizables";

    NodeResolver(Session session, NamePathResolver resolver) {
        this.session = session;
        this.resolver = resolver;
    }

    void setSearchRoots(String userSearchRoot, String groupSearchRoot) {
        this.userSearchRoot = userSearchRoot;
        this.groupSearchRoot = groupSearchRoot;
        this.authorizableSearchRoot = userSearchRoot;
        while (!Text.isDescendant((String)this.authorizableSearchRoot, (String)groupSearchRoot)) {
            this.authorizableSearchRoot = Text.getRelativeParent((String)this.authorizableSearchRoot, (int)1);
        }
    }

    public abstract Node findNode(Name var1, Name var2) throws RepositoryException;

    public abstract Node findNode(Name var1, String var2, Name var3) throws RepositoryException;

    public NodeIterator findNodes(Name propertyName, String value, Name ntName, boolean exact) throws RepositoryException {
        return this.findNodes(Collections.singleton(propertyName), value, ntName, exact, Long.MAX_VALUE);
    }

    public abstract NodeIterator findNodes(Set<Name> var1, String var2, Name var3, boolean var4, long var5) throws RepositoryException;

    Session getSession() {
        return this.session;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    String getSearchRoot(Name ntName) {
        String searchRoot = UserConstants.NT_REP_USER.equals(ntName) ? this.userSearchRoot : (UserConstants.NT_REP_GROUP.equals(ntName) ? this.groupSearchRoot : this.authorizableSearchRoot);
        return searchRoot;
    }
}

