/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferCounterCell;
import org.apache.cassandra.db.BufferCounterUpdateCell;
import org.apache.cassandra.db.BufferDeletedCell;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnSerializer
implements ISerializer<Cell> {
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;
    public static final int COUNTER_MASK = 4;
    public static final int COUNTER_UPDATE_MASK = 8;
    public static final int RANGE_TOMBSTONE_MASK = 16;
    private final CellNameType type;

    public ColumnSerializer(CellNameType type) {
        this.type = type;
    }

    @Override
    public void serialize(Cell cell, DataOutputPlus out) throws IOException {
        assert (!cell.name().isEmpty());
        this.type.cellSerializer().serialize(cell.name(), out);
        try {
            out.writeByte(cell.serializationFlags());
            if (cell instanceof CounterCell) {
                out.writeLong(((CounterCell)cell).timestampOfLastDelete());
            } else if (cell instanceof ExpiringCell) {
                out.writeInt(((ExpiringCell)cell).getTimeToLive());
                out.writeInt(cell.getLocalDeletionTime());
            }
            out.writeLong(cell.timestamp());
            ByteBufferUtil.writeWithLength(cell.value(), out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Cell deserialize(DataInput in) throws IOException {
        return this.deserialize(in, Flag.LOCAL);
    }

    public Cell deserialize(DataInput in, Flag flag) throws IOException {
        return this.deserialize(in, flag, Integer.MIN_VALUE);
    }

    public Cell deserialize(DataInput in, Flag flag, int expireBefore) throws IOException {
        CellName name = this.type.cellSerializer().deserialize(in);
        int b = in.readUnsignedByte();
        return this.deserializeColumnBody(in, name, b, flag, expireBefore);
    }

    Cell deserializeColumnBody(DataInput in, CellName name, int mask, Flag flag, int expireBefore) throws IOException {
        if ((mask & 4) != 0) {
            long timestampOfLastDelete = in.readLong();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            return BufferCounterCell.create(name, value, ts, timestampOfLastDelete, flag);
        }
        if ((mask & 2) != 0) {
            int ttl = in.readInt();
            int expiration = in.readInt();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            return BufferExpiringCell.create(name, value, ts, ttl, expiration, expireBefore, flag);
        }
        long ts = in.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(in);
        return (mask & 8) != 0 ? new BufferCounterUpdateCell(name, value, ts) : ((mask & 1) == 0 ? new BufferCell(name, value, ts) : new BufferDeletedCell(name, value, ts));
    }

    void skipColumnBody(DataInput in, int mask) throws IOException {
        if ((mask & 4) != 0) {
            FileUtils.skipBytesFully(in, 16);
        } else if ((mask & 2) != 0) {
            FileUtils.skipBytesFully(in, 16);
        } else {
            FileUtils.skipBytesFully(in, 8);
        }
        int length = in.readInt();
        FileUtils.skipBytesFully(in, length);
    }

    @Override
    public long serializedSize(Cell cell, TypeSizes typeSizes) {
        return cell.serializedSize(this.type, typeSizes);
    }

    public static class CorruptColumnException
    extends IOException {
        public CorruptColumnException(String s) {
            super(s);
        }

        public static CorruptColumnException create(DataInput in, ByteBuffer name) {
            assert (name.remaining() <= 0);
            String format = "invalid column name length %d%s";
            String details = "";
            if (in instanceof FileDataInput) {
                long remaining;
                FileDataInput fdis = (FileDataInput)in;
                try {
                    remaining = fdis.bytesRemaining();
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, fdis.getPath());
                }
                details = String.format(" (%s, %d bytes remaining)", fdis.getPath(), remaining);
            }
            return new CorruptColumnException(String.format(format, name.remaining(), details));
        }
    }

    public static enum Flag {
        LOCAL,
        FROM_REMOTE,
        PRESERVE_SIZE;

    }
}

