/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.util.Properties;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCacheReplicatorFactory
extends CacheEventListenerFactory {
    private static final String ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS = "asynchronousReplicationIntervalMillis";
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsCacheReplicatorFactory.class.getName());
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";

    public CacheEventListener createCacheEventListener(Properties properties) {
        LOG.debug("Creating JGroups CacheEventListener with configuration: {}", (Object)properties);
        boolean replicatePuts = this.extractBooleanProperty(properties, REPLICATE_PUTS, true);
        boolean replicateUpdates = this.extractBooleanProperty(properties, REPLICATE_UPDATES, true);
        boolean replicateUpdatesViaCopy = this.extractBooleanProperty(properties, REPLICATE_UPDATES_VIA_COPY, false);
        boolean replicateRemovals = this.extractBooleanProperty(properties, REPLICATE_REMOVALS, true);
        boolean replicateAsync = this.extractBooleanProperty(properties, REPLICATE_ASYNCHRONOUSLY, true);
        if (replicateAsync) {
            long asyncTime = this.extractAsynchronousReplicationIntervalMillis(properties);
            return new JGroupsCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, asyncTime);
        }
        return new JGroupsCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
    }

    protected long extractAsynchronousReplicationIntervalMillis(Properties properties) {
        String parsedString = PropertyUtil.extractAndLogProperty((String)ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS, (Properties)properties);
        if (parsedString == null) {
            return 1000L;
        }
        try {
            return Long.parseLong(parsedString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Number format exception trying to set {}. Using the default instead. String value was: '{}'", (Object)ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS, (Object)parsedString);
            return 1000L;
        }
    }

    protected boolean extractBooleanProperty(Properties properties, String propertyName, boolean defaultValue) {
        String booleanCandidate = PropertyUtil.extractAndLogProperty((String)propertyName, (Properties)properties);
        if (booleanCandidate != null) {
            return Boolean.parseBoolean(booleanCandidate);
        }
        return defaultValue;
    }
}

