/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JTATransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.JTAHelper;
import org.hibernate.util.NamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTATransactionFactory
implements TransactionFactory {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private static final Logger log = LoggerFactory.getLogger(JTATransactionFactory.class);
    protected InitialContext initialContext;
    protected String userTransactionName;

    public void configure(Properties props) throws HibernateException {
        this.initialContext = this.resolveInitialContext(props);
        this.userTransactionName = this.resolveUserTransactionName(props);
        log.trace("Configured JTATransactionFactory to use [{}] for UserTransaction JDNI namespace", (Object)this.userTransactionName);
    }

    protected final InitialContext resolveInitialContext(Properties properties) {
        try {
            return NamingHelper.getInitialContext(properties);
        }
        catch (NamingException ne) {
            throw new HibernateException("Could not obtain initial context", ne);
        }
    }

    protected final String resolveUserTransactionName(Properties properties) {
        TransactionManagerLookup lookup;
        String utName = properties.getProperty("jta.UserTransaction");
        if (utName == null && (lookup = TransactionManagerLookupFactory.getTransactionManagerLookup(properties)) != null) {
            utName = lookup.getUserTransactionName();
        }
        return utName == null ? DEFAULT_USER_TRANSACTION_NAME : utName;
    }

    public Transaction createTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) throws HibernateException {
        UserTransaction ut = this.getUserTransaction();
        return new JTATransaction(ut, jdbcContext, transactionContext);
    }

    protected UserTransaction getUserTransaction() {
        String utName = this.getUserTransactionName();
        log.trace("Attempting to locate UserTransaction via JNDI [{}]", (Object)utName);
        try {
            UserTransaction ut = (UserTransaction)this.getInitialContext().lookup(utName);
            if (ut == null) {
                throw new TransactionException("Naming service lookup for UserTransaction returned null [" + utName + "]");
            }
            log.trace("Obtained UserTransaction");
            return ut;
        }
        catch (NamingException ne) {
            throw new TransactionException("Could not find UserTransaction in JNDI [" + utName + "]", ne);
        }
    }

    protected InitialContext getInitialContext() {
        return this.initialContext;
    }

    protected String getUserTransactionName() {
        return this.userTransactionName;
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public boolean isTransactionManagerRequired() {
        return false;
    }

    public boolean areCallbacksLocalToHibernateTransactions() {
        return false;
    }

    public boolean isTransactionInProgress(JDBCContext jdbcContext, TransactionFactory.Context transactionContext, Transaction transaction) {
        try {
            UserTransaction ut;
            if (transaction != null && (ut = ((JTATransaction)transaction).getUserTransaction()) != null) {
                return JTAHelper.isInProgress(ut.getStatus());
            }
            if (jdbcContext.getFactory().getTransactionManager() != null) {
                return JTAHelper.isInProgress(jdbcContext.getFactory().getTransactionManager().getStatus());
            }
            ut = this.getUserTransaction();
            return ut != null && JTAHelper.isInProgress(ut.getStatus());
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", se);
        }
    }
}

