/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.Collections;
import lombok.core.AST;
import lombok.core.configuration.BubblingConfigurationResolver;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.configuration.ConfigurationProblemReporter;
import lombok.core.configuration.ConfigurationResolver;
import lombok.core.configuration.ConfigurationResolverFactory;
import lombok.core.configuration.FileSystemSourceCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LombokConfiguration {
    private static final ConfigurationResolver NULL_RESOLVER = new ConfigurationResolver(){

        @Override
        public <T> T resolve(ConfigurationKey<T> key) {
            if (key.getType().isList()) {
                return (T)Collections.emptyList();
            }
            return null;
        }
    };
    private static FileSystemSourceCache cache = new FileSystemSourceCache();
    private static ConfigurationResolverFactory configurationResolverFactory = System.getProperty("lombok.disableConfig") != null ? new ConfigurationResolverFactory(){

        @Override
        public ConfigurationResolver createResolver(AST<?, ?, ?> ast) {
            return NULL_RESOLVER;
        }
    } : LombokConfiguration.createFileSystemBubblingResolverFactory();

    private LombokConfiguration() {
    }

    public static void overrideConfigurationResolverFactory(ConfigurationResolverFactory crf) {
        configurationResolverFactory = crf == null ? LombokConfiguration.createFileSystemBubblingResolverFactory() : crf;
    }

    static <T> T read(ConfigurationKey<T> key, AST<?, ?, ?> ast) {
        return configurationResolverFactory.createResolver(ast).resolve(key);
    }

    private static ConfigurationResolverFactory createFileSystemBubblingResolverFactory() {
        return new ConfigurationResolverFactory(){

            @Override
            public ConfigurationResolver createResolver(AST<?, ?, ?> ast) {
                return new BubblingConfigurationResolver(cache.sourcesForJavaFile(ast.getAbsoluteFileLocation(), ConfigurationProblemReporter.CONSOLE));
            }
        };
    }
}

