/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.TrackedServletRequest;
import com.liferay.portal.kernel.servlet.taglib.FileAvailabilityUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.CustomJspRegistryUtil;
import com.liferay.taglib.util.AttributesTagSupport;
import com.liferay.taglib.util.ThemeUtil;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class IncludeTag
extends AttributesTagSupport {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = false;
    private static final boolean _THEME_JSP_OVERRIDE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"theme.jsp.override.enabled"));
    private static Log _log = LogFactoryUtil.getLog(IncludeTag.class);
    private String _page;
    private boolean _strict;
    private TrackedServletRequest _trackedRequest;
    private boolean _useCustomPage = true;

    public int doEndTag() throws JspException {
        try {
            String page = null;
            if (this._useCustomPage) {
                page = this.getCustomPage(this.servletContext, this.request);
            }
            if (Validator.isNull(page)) {
                page = this.getPage();
            }
            if (Validator.isNull(page)) {
                page = this.getEndPage();
            }
            this.callSetAttributes();
            if (this.themeResourceExists(page)) {
                this.doIncludeTheme(page);
                return 6;
            }
            if (!FileAvailabilityUtil.isAvailable((ServletContext)this.servletContext, (String)page)) {
                int n = this.processEndTag();
                return n;
            }
            this.doInclude(page);
            return 6;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.clearDynamicAttributes();
            this.clearParams();
            this.clearProperties();
            this.cleanUpSetAttributes();
            if (!ServerDetector.isResin()) {
                this.setPage(null);
                this.setUseCustomPage(true);
                this.cleanUp();
            }
        }
    }

    public int doStartTag() throws JspException {
        String page;
        block4: {
            try {
                page = this.getStartPage();
                this.callSetAttributes();
                if (!this.themeResourceExists(page)) break block4;
                this.doIncludeTheme(page);
                return 1;
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        if (!FileAvailabilityUtil.isAvailable((ServletContext)this.servletContext, (String)page)) {
            return this.processStartTag();
        }
        this.doInclude(page);
        return 1;
    }

    public void runTag() throws JspException {
        this.doStartTag();
        this.doEndTag();
    }

    public void setPage(String page) {
        this._page = page;
    }

    public void setPortletId(String portletId) {
        if (Validator.isNotNull((String)portletId)) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            PortletBag portletBag = PortletBagPool.get((String)rootPortletId);
            this.servletContext = portletBag.getServletContext();
        }
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public void setUseCustomPage(boolean useCustomPage) {
        this._useCustomPage = useCustomPage;
    }

    protected void callSetAttributes() {
        HttpServletRequest request = this.getOriginalServletRequest();
        if (this.isCleanUpSetAttributes()) {
            this._trackedRequest = new TrackedServletRequest(request);
            request = this._trackedRequest;
        }
        this.setNamespacedAttribute(request, "bodyContent", this.getBodyContent());
        this.setNamespacedAttribute(request, "dynamicAttributes", this.getDynamicAttributes());
        this.setNamespacedAttribute(request, "scopedAttributes", this.getScopedAttributes());
        this.setAttributes(request);
    }

    protected void cleanUp() {
    }

    protected void cleanUpSetAttributes() {
        if (this.isCleanUpSetAttributes()) {
            for (String name : this._trackedRequest.getSetAttributes()) {
                this._trackedRequest.removeAttribute(name);
            }
            this._trackedRequest = null;
        }
    }

    protected void doInclude(String page) throws JspException {
        block2: {
            try {
                this.include(page);
            }
            catch (Exception e) {
                String currentURL = (String)this.request.getAttribute("CURRENT_URL");
                String message = "Current URL " + currentURL + " generates exception: " + e.getMessage();
                LogUtil.log((Log)_log, (Throwable)e, (String)message);
                if (!(e instanceof JspException)) break block2;
                throw (JspException)e;
            }
        }
    }

    protected void doIncludeTheme(String page) throws Exception {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        Theme theme = (Theme)this.request.getAttribute("THEME");
        ThemeUtil.include(this.servletContext, this.request, response, this.pageContext, page, theme);
    }

    protected String getCustomPage(ServletContext servletContext, HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return null;
        }
        Group group = null;
        try {
            group = StagingUtil.getLiveGroup((long)themeDisplay.getScopeGroupId());
        }
        catch (Exception exception) {
            return null;
        }
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        String customJspServletContextName = typeSettingsProperties.getProperty("customJspServletContextName");
        if (Validator.isNull((String)customJspServletContextName)) {
            return null;
        }
        String page = this.getPage();
        if (Validator.isNull((String)page)) {
            page = this.getEndPage();
        }
        if (Validator.isNull((String)page)) {
            return null;
        }
        String customPage = CustomJspRegistryUtil.getCustomJspFileName((String)customJspServletContextName, (String)page);
        if (FileAvailabilityUtil.isAvailable((ServletContext)servletContext, (String)customPage)) {
            return customPage;
        }
        return null;
    }

    protected String getEndPage() {
        return null;
    }

    protected HttpServletRequest getOriginalServletRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    protected String getPage() {
        return this._page;
    }

    protected String getStartPage() {
        return null;
    }

    protected void include(String page) throws Exception {
        RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)this.servletContext, (String)page);
        this.request.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT", (Object)this._strict);
        PipingServletResponse response = new PipingServletResponse(this.pageContext);
        requestDispatcher.include((ServletRequest)this.request, (ServletResponse)response);
        this.request.removeAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT");
    }

    protected boolean isCleanUpSetAttributes() {
        return false;
    }

    protected boolean isUseCustomPage() {
        return this._useCustomPage;
    }

    protected int processEndTag() throws Exception {
        return 6;
    }

    protected int processStartTag() throws Exception {
        return 1;
    }

    protected void setAttributes(HttpServletRequest request) {
    }

    protected boolean themeResourceExists(String page) throws Exception {
        ThemeDisplay themeDisplay;
        if (page == null || !_THEME_JSP_OVERRIDE_ENABLED || this._strict) {
            return false;
        }
        Theme theme = (Theme)this.request.getAttribute("THEME");
        if (theme == null && (themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")) != null) {
            theme = themeDisplay.getTheme();
        }
        if (theme == null) {
            return false;
        }
        String portletId = ThemeUtil.getPortletId(this.request);
        boolean exists = theme.resourceExists(this.servletContext, portletId, page);
        if (_log.isDebugEnabled() && exists) {
            String resourcePath = theme.getResourcePath(this.servletContext, null, page);
            _log.debug((Object)resourcePath);
        }
        return exists;
    }
}

