/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ExecuteWithFailover;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.InterruptedOperationException;
import com.netflix.astyanax.connectionpool.exceptions.IsDeadConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.IsTimeoutException;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.connectionpool.exceptions.PoolTimeoutException;
import com.netflix.astyanax.connectionpool.impl.AbstractExecuteWithFailoverImpl;
import com.netflix.astyanax.connectionpool.impl.AbstractHostPartitionConnectionPool;
import java.util.List;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BagOfConnectionsConnectionPoolImpl<CL>
extends AbstractHostPartitionConnectionPool<CL> {
    private final LinkedBlockingQueue<Connection<CL>> idleConnections = new LinkedBlockingQueue();
    private final AtomicInteger activeConnectionCount = new AtomicInteger(0);
    private final Random randomIndex = new Random();

    public BagOfConnectionsConnectionPoolImpl(ConnectionPoolConfiguration config, ConnectionFactory<CL> factory, ConnectionPoolMonitor monitor) {
        super(config, factory, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> Connection<CL> borrowConnection(Operation<CL, R> op) throws ConnectionException {
        long startTime = System.currentTimeMillis();
        Connection<CL> connection = null;
        boolean newConnection = false;
        try {
            connection = this.idleConnections.poll();
            if (connection != null) {
                Connection<CL> connection2 = connection;
                return connection2;
            }
            if (this.activeConnectionCount.incrementAndGet() > this.config.getMaxConns()) {
                this.activeConnectionCount.decrementAndGet();
                try {
                    connection = this.idleConnections.poll(this.config.getMaxTimeoutWhenExhausted(), TimeUnit.MILLISECONDS);
                    if (connection == null) {
                        throw new PoolTimeoutException("Timed out waiting for connection from bag");
                    }
                    Connection<CL> connection3 = connection;
                    return connection3;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedOperationException("Interrupted waiting to borrow a connection");
                }
            }
            try {
                newConnection = true;
                List pools = this.topology.getAllPools().getPools();
                if (pools == null) throw new NoAvailableHostsException("No hosts to borrow from");
                if (pools.size() <= 0) throw new NoAvailableHostsException("No hosts to borrow from");
                int index = this.randomIndex.nextInt(pools.size());
                int i = 0;
                while (i < pools.size()) {
                    HostConnectionPool pool = pools.get(index % pools.size());
                    try {
                        Connection<CL> connection4 = connection = pool.borrowConnection(this.config.getConnectTimeout());
                        return connection4;
                    }
                    catch (ConnectionException connectionException) {
                        ++i;
                        ++index;
                    }
                }
                throw new NoAvailableHostsException("Too many errors trying to open a connection");
            }
            finally {
                if (connection == null) {
                    this.activeConnectionCount.decrementAndGet();
                }
            }
        }
        finally {
            if (connection != null && !newConnection) {
                this.monitor.incConnectionBorrowed(connection.getHostConnectionPool().getHost(), System.currentTimeMillis() - startTime);
            }
        }
    }

    protected boolean returnConnection(Connection<CL> connection) {
        if (connection != null) {
            if (connection.getHostConnectionPool().isReconnecting() || connection.getOperationCount() > (long)this.config.getMaxOperationsPerConnection()) {
                this.closeConnection(connection);
            } else {
                ConnectionException ce = connection.getLastException();
                if (ce != null && (ce instanceof IsDeadConnectionException || ce instanceof IsTimeoutException)) {
                    this.closeConnection(connection);
                } else if (!this.idleConnections.offer(connection)) {
                    this.closeConnection(connection);
                } else {
                    this.monitor.incConnectionReturned(connection.getHostConnectionPool().getHost());
                }
            }
            return true;
        }
        return false;
    }

    private void closeConnection(Connection<CL> connection) {
        connection.getHostConnectionPool().closeConnection(connection);
        this.activeConnectionCount.decrementAndGet();
    }

    @Override
    public <R> ExecuteWithFailover<CL, R> newExecuteWithFailover(Operation<CL, R> op) throws ConnectionException {
        return new BagExecuteWithFailover(this.config);
    }

    class BagExecuteWithFailover<R>
    extends AbstractExecuteWithFailoverImpl<CL, R> {
        private int retryCountdown;
        private HostConnectionPool<CL> pool;
        private int size;

        public BagExecuteWithFailover(ConnectionPoolConfiguration config) throws ConnectionException {
            super(config, BagOfConnectionsConnectionPoolImpl.this.monitor);
            this.pool = null;
            this.size = 0;
            this.size = BagOfConnectionsConnectionPoolImpl.this.topology.getAllPools().getPools().size();
            this.retryCountdown = Math.min(config.getMaxFailoverCount(), this.size);
            if (this.retryCountdown < 0) {
                this.retryCountdown = this.size;
            }
        }

        @Override
        public HostConnectionPool<CL> getCurrentHostConnectionPool() {
            return this.pool;
        }

        @Override
        public Connection<CL> borrowConnection(Operation<CL, R> operation) throws ConnectionException {
            this.pool = null;
            this.connection = BagOfConnectionsConnectionPoolImpl.this.borrowConnection(operation);
            this.pool = this.connection.getHostConnectionPool();
            return this.connection;
        }

        @Override
        public boolean canRetry() {
            return --this.retryCountdown >= 0;
        }

        @Override
        public void releaseConnection() {
            BagOfConnectionsConnectionPoolImpl.this.returnConnection(this.connection);
            this.connection = null;
        }
    }
}

