/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.Chat;
import org.walluck.oscar.TLV;

public class TLVChain
extends ArrayList {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$TLVChain == null ? (class$org$walluck$oscar$TLVChain = TLVChain.class$("org.walluck.oscar.TLVChain")) : class$org$walluck$oscar$TLVChain).getName());
    static /* synthetic */ Class class$org$walluck$oscar$TLVChain;

    public TLVChain() {
        super(11);
    }

    public TLVChain(int size) {
        super(size);
    }

    public void addString(int type, String value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(value.length());
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeBytes(value);
        this.addTLV(new TLV(type, value.length(), baos.toByteArray()));
    }

    public void addNull(int type) throws IOException {
        this.addTLV(new TLV(type, 0, null));
    }

    public void addByte(int type, int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(value);
        this.addTLV(new TLV(type, 1, baos.toByteArray()));
    }

    public void addBytes(int type, byte[] value) throws IOException {
        this.addTLV(new TLV(type, value.length, value));
    }

    public void addShort(int type, int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(value);
        this.addTLV(new TLV(type, 2, baos.toByteArray()));
    }

    public void addInt(int type, int value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(value);
        this.addTLV(new TLV(type, 4, baos.toByteArray()));
    }

    public void addTLV(TLV tlv) {
        this.add(tlv);
    }

    public void addTLVChain(int type, TLVChain tlvchain) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AIMOutputStream buffer = new AIMOutputStream(baos);
        buffer.writeTLVChain(tlvchain);
        this.addBytes(type, baos.toByteArray());
    }

    public void addCaps(int type, int caps) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AIMOutputStream buffer = new AIMOutputStream(baos);
        buffer.writeCaps(caps);
        this.addBytes(type, baos.toByteArray());
    }

    public void addChatRoom(int type, Chat chat) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AIMOutputStream buffer = new AIMOutputStream(baos);
        buffer.writeShort(chat.getExchange());
        buffer.writeStringL(chat.getName());
        buffer.writeShort(chat.getInstance());
        this.addBytes(type, baos.toByteArray());
    }

    public int length() {
        int length = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            TLV tlv = (TLV)this.get(i);
            length += tlv.getLength();
        }
        return length + 4 * size;
    }

    public int size() {
        return super.size();
    }

    public TLV getTLV(int type, int n) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            TLV tlv = (TLV)this.get(i);
            if (tlv.getType() != type || ++count != n) continue;
            return tlv;
        }
        return null;
    }

    public void removeTLV(int type, int n) {
        TLV tlv = this.getTLV(type, n);
        if (tlv != null) {
            this.remove(tlv);
        }
    }

    public Object clone() {
        TLVChain tlvchain = new TLVChain(this.size());
        Iterator i = this.iterator();
        while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            TLV tlv2 = new TLV();
            tlv2.setType(tlv.getType());
            tlv2.setLength(tlv.getLength());
            byte[] b = tlv.getValue();
            if (b != null) {
                tlv2.setValue(new byte[b.length]);
                System.arraycopy(tlv2.getValue(), 0, b, 0, b.length);
            }
            tlvchain.addTLV(tlv2);
        }
        return tlvchain;
    }

    public boolean equals(Object obj) {
        int length2;
        TLVChain tlvchain = (TLVChain)obj;
        int length1 = this.length();
        if (length1 != (length2 = tlvchain.length())) {
            return false;
        }
        try {
            AIMOutputStream buffer1 = new AIMOutputStream(length1);
            AIMOutputStream buffer2 = new AIMOutputStream(length2);
            buffer1.writeTLVChain(this);
            buffer2.writeTLVChain(tlvchain);
            byte[] b1 = buffer1.getBytes();
            byte[] b2 = buffer2.getBytes();
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.iterator();
        if (!i.hasNext()) {
            sb.append("no TLV's present");
            return sb.toString();
        }
        while (true) {
            TLV tlv = (TLV)i.next();
            sb.append(tlv.toString());
            if (!i.hasNext()) break;
            sb.append(", ");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

