/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.InputStream;
import java.util.List;

public class CompanyServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(CompanyServiceHttp.class);
    private static final Class<?>[] _addCompanyParameterTypes0 = new Class[]{String.class, String.class, String.class, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE};
    private static final Class<?>[] _deleteCompanyParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteLogoParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCompanyByIdParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCompanyByLogoIdParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCompanyByMxParameterTypes5 = new Class[]{String.class};
    private static final Class<?>[] _getCompanyByVirtualHostParameterTypes6 = new Class[]{String.class};
    private static final Class<?>[] _getCompanyByWebIdParameterTypes7 = new Class[]{String.class};
    private static final Class<?>[] _removePreferencesParameterTypes8 = new Class[]{Long.TYPE, String[].class};
    private static final Class<?>[] _updateCompanyParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, Boolean.TYPE};
    private static final Class<?>[] _updateCompanyParameterTypes10 = new Class[]{Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static final Class<?>[] _updateCompanyParameterTypes11 = new Class[]{Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, List.class, List.class, List.class, List.class, UnicodeProperties.class};
    private static final Class<?>[] _updateDisplayParameterTypes12 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateLogoParameterTypes13 = new Class[]{Long.TYPE, byte[].class};
    private static final Class<?>[] _updateLogoParameterTypes14 = new Class[]{Long.TYPE, InputStream.class};
    private static final Class<?>[] _updatePreferencesParameterTypes15 = new Class[]{Long.TYPE, UnicodeProperties.class};
    private static final Class<?>[] _updateSecurityParameterTypes16 = new Class[]{Long.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE};

    public static Company addCompany(HttpPrincipal httpPrincipal, String webId, String virtualHost, String mx, String shardName, boolean system, int maxUsers, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "addCompany", (Class[])_addCompanyParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{webId, virtualHost, mx, shardName, system, maxUsers, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company deleteCompany(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "deleteCompany", (Class[])_deleteCompanyParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLogo(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "deleteLogo", (Class[])_deleteLogoParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyById(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "getCompanyById", (Class[])_getCompanyByIdParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByLogoId(HttpPrincipal httpPrincipal, long logoId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "getCompanyByLogoId", (Class[])_getCompanyByLogoIdParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{logoId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByMx(HttpPrincipal httpPrincipal, String mx) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "getCompanyByMx", (Class[])_getCompanyByMxParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{mx});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByVirtualHost(HttpPrincipal httpPrincipal, String virtualHost) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "getCompanyByVirtualHost", (Class[])_getCompanyByVirtualHostParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{virtualHost});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByWebId(HttpPrincipal httpPrincipal, String webId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "getCompanyByWebId", (Class[])_getCompanyByWebIdParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{webId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removePreferences(HttpPrincipal httpPrincipal, long companyId, String[] keys) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "removePreferences", (Class[])_removePreferencesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, keys});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, int maxUsers, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateCompany", (Class[])_updateCompanyParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, virtualHost, mx, maxUsers, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateCompany", (Class[])_updateCompanyParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size, String languageId, String timeZoneId, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, UnicodeProperties properties) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateCompany", (Class[])_updateCompanyParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size, languageId, timeZoneId, addresses, emailAddresses, phones, websites, properties});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateDisplay(HttpPrincipal httpPrincipal, long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateDisplay", (Class[])_updateDisplayParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, languageId, timeZoneId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateLogo(HttpPrincipal httpPrincipal, long companyId, byte[] bytes) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateLogo", (Class[])_updateLogoParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, bytes});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateLogo(HttpPrincipal httpPrincipal, long companyId, InputStream inputStream) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateLogo", (Class[])_updateLogoParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, inputStream});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updatePreferences(HttpPrincipal httpPrincipal, long companyId, UnicodeProperties properties) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updatePreferences", (Class[])_updatePreferencesParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, properties});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateSecurity(HttpPrincipal httpPrincipal, long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(CompanyServiceUtil.class, "updateSecurity", (Class[])_updateSecurityParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, authType, autoLogin, sendPassword, strangers, strangersWithMx, strangersVerify, siteLogo});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

