/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.ldap;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.ldap.LDAPFilterException;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class LDAPUtil {
    public static Object getAttributeObject(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id);
    }

    public static Object getAttributeObject(Attributes attributes, Properties properties, String key, Object defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id, defaultValue);
    }

    public static Object getAttributeObject(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeObject(attributes, id, null);
    }

    public static Object getAttributeObject(Attributes attributes, String id, Object defaultValue) throws NamingException {
        if (Validator.isNull(id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object;
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id);
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key, String defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id, defaultValue);
    }

    public static String getAttributeString(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeString(attributes, id, "");
    }

    public static String getAttributeString(Attributes attributes, String id, String defaultValue) throws NamingException {
        if (Validator.isNull(id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static String[] getAttributeStringArray(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeStringArray(attributes, id);
    }

    public static String[] getAttributeStringArray(Attributes attributes, String id) throws NamingException {
        if (Validator.isNull(id)) {
            return null;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return new String[0];
        }
        int size = attribute.size();
        if (size == 0) {
            return null;
        }
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            Object object = attribute.get(i);
            array[i] = object == null ? "" : object.toString();
            ++i;
        }
        return array;
    }

    public static String getFullProviderURL(String baseURL, String baseDN) {
        return String.valueOf(baseURL) + "/" + baseDN;
    }

    public static boolean isValidFilter(String filter) {
        if (Validator.isNull(filter)) {
            return true;
        }
        if ((filter = filter.trim()).equals("*")) {
            return true;
        }
        if (!(filter = StringUtil.replace(filter, " ", "")).startsWith("(") || !filter.endsWith(")")) {
            return false;
        }
        int count = 0;
        int i = 0;
        while (i < filter.length()) {
            char c = filter.charAt(i);
            if (c == ')') {
                --count;
            } else if (c == '(') {
                ++count;
            }
            if (count < 0) {
                return false;
            }
            ++i;
        }
        if (count > 0) {
            return false;
        }
        if (Pattern.matches(".*[~<>]*=[~<>]*=.*", filter)) {
            return false;
        }
        if (Pattern.matches("\\([~<>]*=.*", filter)) {
            return false;
        }
        if (Pattern.matches("\\([^~<>=]*\\)", filter)) {
            return false;
        }
        return !Pattern.matches(".*[^~<>=]*[~<>]*=\\)", filter);
    }

    public static Date parseDate(String date) throws Exception {
        String format = "yyyyMMddHHmmss";
        if (date.endsWith("Z")) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.S'Z'" : "yyyyMMddHHmmss'Z'";
        } else if (date.indexOf(45) != -1 || date.indexOf(43) != -1) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.SZ" : "yyyyMMddHHmmssZ";
        } else if (date.indexOf(46) != -1) {
            format = "yyyyMMddHHmmss.S";
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    public static void validateFilter(String filter) throws PortalException {
        if (!LDAPUtil.isValidFilter(filter)) {
            throw new LDAPFilterException("Invalid filter " + filter);
        }
    }
}

