/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.common.regression.MakeAnon;
import com.hp.hpl.mesa.rdf.jena.common.regression.ResourceReader;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.BitSet;
import java.util.Random;

public class testWriterAndReader
implements RDFErrorHandler {
    private static boolean showProgress = false;
    private static boolean keepFiles = false;
    private static boolean errorDetail = false;
    private static int firstTest = 5;
    private static int lastTest = 8;
    private static int repetitionsJ = 6;
    private String test = " test testWriterAndReader initialization";
    private int n = 0;
    static final String[] baseUris = new String[]{"http://foo.com/Hello", "http://foo.com/Hello", "http://daml.umbc.edu/ontologies/calendar-ont", "http://www.daml.org/2001/03/daml+oil-ex"};
    BitSet seenError = new BitSet();

    protected static void doTest(Model model, Model model2, Model model3, Model model4) {
        if (showProgress) {
            System.out.println("Each + below corresponds to 80 tests.");
        }
        new testWriterAndReader().test(model, model2, model3, model4);
    }

    public void test(Model model, Model model2, Model model3, Model model4) {
        try {
            this.test("N-TRIPLE", 25, 1, 1, model, model2, model3, model4);
            this.test("RDF/XML-ABBREV", 35, 1, 1, model, model2, model3, model4);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test(String string, int n, int n2, int n3, Model model, Model model2, Model model3, Model model4) throws RDFException {
        this.test = "testWriterAndReader lang=" + string + " seed=" + n;
        String string2 = "modules/rdf/regression/testWriterAndReader/";
        if (showProgress) {
            System.out.println("Beginning " + this.test);
        }
        this.seenError = new BitSet();
        Random random = new Random(n);
        MakeAnon makeAnon = new MakeAnon(string);
        RDFReader rDFReader = model.getReader(string);
        RDFWriter rDFWriter = model.getWriter(string);
        rDFReader.setErrorHandler(this);
        rDFWriter.setErrorHandler(this);
        int n4 = 0;
        block4: while (true) {
            if (n4 >= n2) {
                if (showProgress) {
                    System.out.println("End of " + this.test);
                }
                return;
            }
            int n5 = 0;
            while (true) {
                if (n5 >= n3) {
                    if (showProgress) {
                        System.out.println();
                    }
                    ++n4;
                    continue block4;
                }
                try {
                    int n6 = firstTest;
                    block6: while (n6 <= lastTest) {
                        this.n = 1000 * n6;
                        ++this.n;
                        String string3 = "t" + n6 * 1000 + ".rdf";
                        ++this.n;
                        testWriterAndReader.empty(model);
                        ++this.n;
                        String string4 = n6 < baseUris.length ? baseUris[n6] : "http://foo.com/Hello";
                        ++this.n;
                        InputStreamReader inputStreamReader = new ResourceReader(string2 + string3);
                        ++this.n;
                        model.read(inputStreamReader, string4);
                        ++this.n;
                        ((Reader)inputStreamReader).close();
                        boolean bl = false;
                        int n7 = 0;
                        while (true) {
                            File file;
                            block24: {
                                Object var39_39;
                                Model model5;
                                Model model6;
                                if (n7 >= repetitionsJ) {
                                    ++n6;
                                    continue block6;
                                }
                                this.n = 1000 * n6 + n7 * 100 + 20;
                                file = File.createTempFile("j" + this.n + "t", ".txt");
                                ++this.n;
                                String string5 = n7 % 2 == 0 ? string4 : "http://bar.com/irrelevant";
                                int n8 = (int)model.size();
                                ++this.n;
                                if (n7 % 2 == 0 && n7 > 0) {
                                    this.prune(model, random, 1 + n8 / 10);
                                }
                                ++this.n;
                                if (n7 % 2 == 0 && n7 > 0) {
                                    this.expand(model, random, 1 + n8 / 10);
                                }
                                ++this.n;
                                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                                ++this.n;
                                rDFWriter.write(model, printWriter, string5);
                                ++this.n;
                                printWriter.close();
                                ++this.n;
                                testWriterAndReader.empty(model2);
                                ++this.n;
                                FileInputStream fileInputStream = new FileInputStream(file);
                                ++this.n;
                                inputStreamReader = new InputStreamReader(fileInputStream);
                                ++this.n;
                                rDFReader.read(model2, inputStreamReader, string5);
                                ++this.n;
                                ((InputStream)fileInputStream).close();
                                ++this.n;
                                ((Reader)inputStreamReader).close();
                                ++this.n;
                                Model model7 = makeAnon.makeAnon(model, string5, model3);
                                int n9 = makeAnon.lastCnt();
                                ++this.n;
                                Model model8 = makeAnon.makeAnon(model2, string5, model4);
                                int n10 = makeAnon.lastCnt();
                                if (n9 > 50) {
                                    System.out.println(n9);
                                }
                                ++this.n;
                                if (n9 == n10 && model7.equals(model8)) break block24;
                                bl = true;
                                this.error();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model.write(printWriter);
                                printWriter.close();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model2.write(printWriter);
                                printWriter.close();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model7.write(printWriter);
                                printWriter.close();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model8.write(printWriter);
                                printWriter.close();
                                if (!errorDetail) break block24;
                                int n11 = (int)(model7.size() - model8.size());
                                System.out.print("Diff is " + n11);
                                int n12 = 0;
                                if (n11 >= 0) {
                                    model6 = model7;
                                    model5 = model8;
                                } else {
                                    model6 = model8;
                                    model5 = model7;
                                }
                                StmtIterator stmtIterator = model6.listStatements();
                                try {
                                    while (true) {
                                        RDFNode rDFNode;
                                        block26: {
                                            block25: {
                                                if (n12 >= 10) break block25;
                                                if (stmtIterator.hasNext()) break block26;
                                            }
                                            var39_39 = null;
                                            break;
                                        }
                                        Statement statement = stmtIterator.next();
                                        if (model5.contains(statement) || statement.getSubject().isAnon() || (rDFNode = statement.getObject()) instanceof Resource && ((Resource)rDFNode).isAnon()) continue;
                                        ++n12;
                                        System.out.println(statement);
                                    }
                                }
                                catch (Throwable throwable) {
                                    var39_39 = null;
                                    stmtIterator.close();
                                    throw throwable;
                                }
                                stmtIterator.close();
                            }
                            if (!keepFiles && !bl) {
                                ++this.n;
                                file.delete();
                            }
                            ++n7;
                        }
                    }
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                if (showProgress) {
                    System.out.print("+");
                    System.out.flush();
                }
                ++n5;
            }
            break;
        }
    }

    private void prune(Model model, Random random, int n) throws RDFException {
        int n2;
        Statement[] statementArray = new Statement[n];
        int n3 = (int)model.size();
        StmtIterator stmtIterator = model.listStatements();
        try {
            n2 = 0;
            while (n2 < n) {
                statementArray[n2] = stmtIterator.next();
                ++n2;
            }
            while (stmtIterator.hasNext()) {
                int n4 = random.nextInt(n3);
                if (n4 >= n) continue;
                statementArray[n4] = stmtIterator.next();
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        n2 = 0;
        while (n2 < n) {
            model.remove(statementArray[n2]);
            ++n2;
        }
    }

    private void expand(Model model, Random random, int n) throws RDFException {
        int n2;
        Resource[] resourceArray = new Resource[n];
        Property[] propertyArray = new Property[n];
        RDFNode[] rDFNodeArray = new RDFNode[n];
        int n3 = (int)model.size();
        StmtIterator stmtIterator = model.listStatements();
        try {
            Statement statement;
            n2 = 0;
            while (n2 < n) {
                statement = stmtIterator.next();
                resourceArray[n2] = statement.getSubject();
                propertyArray[n2] = statement.getPredicate();
                rDFNodeArray[n2] = statement.getObject();
                ++n2;
            }
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                Resource resource = statement.getSubject();
                RDFNode rDFNode = statement.getObject();
                int n4 = random.nextInt(n3);
                if (n4 < n) {
                    resourceArray[n4] = resource;
                }
                if ((n4 = random.nextInt(n3)) < n) {
                    rDFNodeArray[n4] = resource;
                }
                if ((n4 = random.nextInt(n3)) < n) {
                    propertyArray[n4] = statement.getPredicate();
                }
                if ((n4 = random.nextInt(n3)) < n) {
                    rDFNodeArray[n4] = rDFNode;
                }
                if (!(rDFNode instanceof Resource) || (n4 = random.nextInt(n3)) >= n) continue;
                resourceArray[n4] = (Resource)rDFNode;
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        n2 = 0;
        while (n2 < n) {
            model.add(resourceArray[n2], propertyArray[n2], rDFNodeArray[n2]);
            ++n2;
        }
    }

    private void error() {
        if (!this.seenError.get(this.n)) {
            System.out.println(this.test + ": failed test " + Integer.toString(this.n));
        }
        this.seenError.set(this.n);
    }

    public void error(Exception exception) {
        if (!this.seenError.get(this.n)) {
            System.out.println("Test Failed: " + this.test + " " + this.n + " " + exception.toString());
        }
        this.seenError.set(this.n);
    }

    public boolean getErrors() {
        return !this.seenError.equals(new BitSet());
    }

    public void warning(Exception exception) {
    }

    public void fatalError(Exception exception) {
        this.error(exception);
        throw new RDFError(exception);
    }

    public static void empty(Model model) throws RDFException {
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            stmtIterator.next();
            stmtIterator.remove();
        }
    }

    static ModelMem load(String string) throws RDFException, IOException {
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileInputStream fileInputStream = new FileInputStream("c:\\" + string);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        rDFReader.read(modelMem, inputStreamReader, "http://should.not.see.me/");
        ((InputStream)fileInputStream).close();
        ((Reader)inputStreamReader).close();
        MakeAnon makeAnon = new MakeAnon("RDF/XML");
        return (ModelMem)makeAnon.makeAnon(modelMem, "http://should.not.see.me/", modelMem2);
    }

    public static void main(String[] stringArray) throws RDFException, IOException {
        showProgress = true;
        firstTest = 1;
        repetitionsJ = 10;
        testWriterAndReader testWriterAndReader2 = new testWriterAndReader();
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        ModelMem modelMem3 = new ModelMem();
        ModelMem modelMem4 = new ModelMem();
        try {
            testWriterAndReader2.test("N-TRIPLE", 25, 1, 2, modelMem, modelMem2, modelMem3, modelMem4);
            testWriterAndReader2.test("RDF/XML-ABBREV", 35, 3, 20, modelMem, modelMem2, modelMem3, modelMem4);
        }
        catch (Exception exception) {
            testWriterAndReader2.error(exception);
        }
    }
}

