/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoIO {
    private DB db;
    private String[] server;
    private MongoClient mongo;
    private String user;
    private String password;
    private Logger logger = LoggerFactory.getLogger(MongoIO.class);
    private GridFS gfs;
    private MemoryType memoryType;
    private String dbName;
    protected static final String DEFAULT_META_COLLECTION = "fs.files";
    protected static final String DEFAULT_DB_NAME = "remotefs";
    protected static final String ROOT_PATH_PATCH_V1 = "/home/null/";
    protected static final String ROOT_PATH_PATCH_V2 = "/public/";
    protected static final String DEFAULT_CHUNKS_COLLECTION = "fs.chunks";
    protected static final WriteConcern DEFAULT_WRITE_TYPE = WriteConcern.REPLICA_ACKNOWLEDGED;
    protected static final ReadPreference DEFAULT_READ_PREFERENCE = ReadPreference.primaryPreferred();

    protected MongoIO(String[] server, String user, String password, MemoryType memoryType, String dbName) {
        this.setServer(server);
        this.setUser(user);
        this.setPassword(password);
        this.setMemoryType(memoryType);
        this.setDbName(dbName);
    }

    protected DB getDB(String writeConcern, String readConcern, String dbName, boolean readwritePreferences) {
        if (dbName == null || dbName.isEmpty()) {
            dbName = DEFAULT_DB_NAME;
        }
        if (this.db == null) {
            try {
                ArrayList<ServerAddress> srvList = new ArrayList<ServerAddress>();
                for (String srv : this.server) {
                    srvList.add(new ServerAddress(srv));
                }
                if (this.mongo == null) {
                    this.logger.debug(" open mongo connection ");
                    MongoClientOptions options = MongoClientOptions.builder().connectionsPerHost(30).connectTimeout(30000).build();
                    if (this.password != null && this.password.length() > 0 && this.user != null && this.user.length() > 0) {
                        MongoCredential credential = MongoCredential.createCredential((String)this.user, (String)dbName, (char[])this.password.toCharArray());
                        this.mongo = new MongoClient(srvList, Arrays.asList(credential), options);
                    } else {
                        this.mongo = new MongoClient(srvList, options);
                    }
                    this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoClientOptions());
                }
                this.db = this.mongo.getDB(dbName);
                if (readwritePreferences && this.memoryType != MemoryType.VOLATILE && srvList.size() > 1) {
                    if (writeConcern != null) {
                        WriteConcern write = new WriteConcern(Integer.parseInt(writeConcern));
                        this.db.setWriteConcern(write);
                    } else {
                        this.db.setWriteConcern(DEFAULT_WRITE_TYPE);
                    }
                    if (readConcern != null) {
                        ReadPreference read = ReadPreference.valueOf((String)readConcern);
                        this.db.setReadPreference(read);
                    } else {
                        this.db.setReadPreference(DEFAULT_READ_PREFERENCE);
                    }
                }
            }
            catch (Exception e) {
                this.close();
                this.logger.error("Problem to open the DB connection for gridfs file ");
                throw new RemoteBackendException("Problem to open the DB connection: " + e.getMessage());
            }
            this.logger.info("new mongo connection pool opened");
        }
        return this.db;
    }

    protected DBCollection getMetaDataCollection() throws UnknownHostException {
        if (this.db == null) {
            this.db = this.getDB(null, null, this.dbName, false);
        }
        return this.db.getCollection(DEFAULT_META_COLLECTION);
    }

    protected DBCollection getMetaDataCollection(DB db) throws UnknownHostException {
        if (db == null) {
            this.db = this.getDB(null, null, this.dbName, false);
            return this.db.getCollection(DEFAULT_META_COLLECTION);
        }
        return db.getCollection(DEFAULT_META_COLLECTION);
    }

    protected DBCollection getCollection(DB db, String collectionName) throws UnknownHostException {
        if (db == null) {
            this.db = this.getDB(null, null, this.dbName, false);
            return this.db.getCollection(collectionName);
        }
        return db.getCollection(collectionName);
    }

    protected GridFSDBFile retrieveRemoteDescriptor(String serverLocation, boolean retry) {
        this.logger.info("MongoDB - retrieve object from pathServer: " + serverLocation);
        GridFSDBFile f = null;
        try {
            GridFS gfs = new GridFS(this.getDB(null, null, this.dbName, false));
            if (ObjectId.isValid((String)serverLocation)) {
                try {
                    BasicDBObject query = new BasicDBObject();
                    query.put((Object)"_id", (Object)new ObjectId(serverLocation));
                    f = gfs.findOne((DBObject)query);
                }
                catch (Exception e) {
                    this.logger.warn("the file " + serverLocation + " is not a valid objectId " + e.getMessage());
                    f = null;
                }
                if (retry && f == null) {
                    int i = 0;
                    while (f == null && i < 5) {
                        this.logger.info(" retry to search file " + serverLocation);
                        Thread.sleep(500L);
                        try {
                            BasicDBObject query = new BasicDBObject();
                            query.put((Object)"_id", (Object)new ObjectId(serverLocation));
                            f = gfs.findOne((DBObject)query);
                            ++i;
                        }
                        catch (Exception e) {
                            this.logger.warn("the file " + serverLocation + " is not a valid objectId " + e.getMessage());
                            f = null;
                        }
                    }
                }
            } else {
                this.logger.info("remote object is not a validID : " + serverLocation);
                if (retry && f == null) {
                    f = gfs.findOne(serverLocation);
                    for (int i = 0; f == null && i < 5; ++i) {
                        this.logger.info(" retry to search file " + serverLocation);
                        Thread.sleep(500L);
                        f = gfs.findOne(serverLocation);
                    }
                }
            }
            if (f == null) {
                f = this.patchRemoteFilePathVersion1(serverLocation, gfs);
            }
            if (f != null) {
                this.logger.info("object found " + f.get("name"));
            } else {
                this.logger.info("object not found ");
            }
        }
        catch (Exception e) {
            this.logger.error("problem retrieving remote object: " + serverLocation + " " + e.getMessage());
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return f;
    }

    protected List<GridFSDBFile> retrieveRemoteObjects(BasicDBObject query) throws UnknownHostException {
        GridFS gfs = this.getGfs();
        return gfs.find((DBObject)query);
    }

    protected GridFSDBFile retrieveLinkPayload(GridFSDBFile f) throws UnknownHostException {
        while (f.containsField("link") && f.get("link") != null) {
            String id = (String)f.get("link");
            f = this.getGfs().find(new ObjectId(id));
        }
        return f;
    }

    private GridFSDBFile patchRemoteFilePathVersion1(String serverLocation, GridFS gfs) {
        GridFSDBFile f = null;
        String path = serverLocation;
        String locationV1 = null;
        if (serverLocation.contains(ROOT_PATH_PATCH_V1)) {
            locationV1 = path.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
            f = gfs.findOne(locationV1);
            if (f == null) {
                String locationV1patch = locationV1.substring(1);
                f = gfs.findOne(locationV1patch);
            }
        } else if (serverLocation.contains(ROOT_PATH_PATCH_V2) && (f = gfs.findOne(locationV1 = path.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1))) == null) {
            String locationV1patch = "/" + locationV1;
            f = gfs.findOne(locationV1patch);
        }
        return f;
    }

    protected List<GridFSDBFile> patchRemoteDirPathVersion1(String bucket, GridFS gfs, BasicDBObject query, List<GridFSDBFile> list) {
        List patchList = null;
        if (bucket.contains(ROOT_PATH_PATCH_V1)) {
            String locationV2 = bucket.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put((Object)"dir", (Object)locationV2);
            patchList = gfs.find((DBObject)queryPatch);
        } else if (bucket.contains(ROOT_PATH_PATCH_V2)) {
            String locationV1 = bucket.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1);
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put((Object)"dir", (Object)locationV1);
            patchList = gfs.find((DBObject)queryPatch);
            String locationV1patch = "/" + locationV1;
            queryPatch = new BasicDBObject();
            queryPatch.put((Object)"dir", (Object)locationV1patch);
            List patchList2 = gfs.find((DBObject)queryPatch);
            if (patchList2 != null && !patchList2.isEmpty()) {
                if (patchList != null) {
                    patchList.addAll(patchList2);
                } else {
                    patchList = patchList2;
                }
            }
        }
        if (patchList != null && !patchList.isEmpty()) {
            list.addAll(patchList);
        }
        return list;
    }

    protected BasicDBObject findMetaCollectionObject(String source) throws UnknownHostException {
        DBCollection fileCollection = this.getDB(null, null, this.dbName, false).getCollection(DEFAULT_META_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        BasicDBObject obj = null;
        query.put((Object)"filename", (Object)source);
        DBCursor cursor = fileCollection.find((DBObject)query);
        if (cursor != null && !cursor.hasNext()) {
            query = new BasicDBObject();
            query.put((Object)"_id", (Object)new ObjectId(source));
            cursor = fileCollection.find((DBObject)query);
        }
        if (cursor.hasNext()) {
            obj = (BasicDBObject)cursor.next();
            String path = (String)obj.get("filename");
            this.logger.debug("path found " + path);
        }
        return obj;
    }

    protected DBObject findCollectionObject(DBCollection collection, BasicDBObject query) throws UnknownHostException {
        DBObject obj = null;
        obj = collection.findOne((DBObject)query);
        return obj;
    }

    protected DBCursor findCollectionObjects(DBCollection collection, BasicDBObject query) throws UnknownHostException {
        DBCursor cursor = collection.find((DBObject)query);
        return cursor;
    }

    protected GridFSDBFile findGFSCollectionObject(ObjectId id) {
        return this.getGfs().find(id);
    }

    protected DBObject executeQuery(DBCollection fileCollection, BasicDBObject query) throws UnknownHostException {
        DBCursor cursor;
        if (fileCollection == null) {
            fileCollection = this.getMetaDataCollection(this.getDB(null, null, this.dbName, false));
        }
        if ((cursor = fileCollection.find((DBObject)query)).hasNext()) {
            return cursor.next();
        }
        return null;
    }

    protected String readByInputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) {
        String key = null;
        resource.setInputStream((InputStream)((Object)new MongoInputStream(this.mongo, f.getInputStream())));
        return key;
    }

    protected String readByOutputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        f.writeTo(resource.getOutputStream());
        resource.setOutputStream(null);
        f.save();
        return key;
    }

    protected String readByPath(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        try {
            File file = new File(resource.getLocalPath());
            f.writeTo(file);
            resource.setLocalPath(null);
        }
        catch (IOException e) {
            this.logger.error("Connection error. " + e.getMessage());
            if (count < 5) {
                this.logger.info(" Retry : #" + ++count);
                this.readByPath(resource, f, isLock, count);
            }
            this.close();
            this.logger.error("max number of retry completed ");
            throw new RuntimeException(e);
        }
        return key;
    }

    protected GridFSInputFile createGFSFileObject(InputStream is, String writeConcern, String readPreference) throws UnknownHostException {
        GridFS gfs = new GridFS(this.getDB(writeConcern, readPreference, this.dbName, true));
        GridFSInputFile f2 = gfs.createFile(is);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(String name, String writeConcern, String readPreference) throws IOException {
        GridFS gfs = new GridFS(this.getDB(writeConcern, readPreference, this.dbName, true));
        GridFSInputFile f2 = gfs.createFile(name);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(File f, String writeConcern, String readPreference) {
        GridFS gfs = new GridFS(this.getDB(writeConcern, readPreference, this.dbName, true));
        GridFSInputFile f2 = null;
        try {
            f2 = gfs.createFile(f);
        }
        catch (IOException e) {
            this.logger.error("problem in creation remote file " + f.getAbsolutePath());
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(byte[] b, String writeConcern, String readPreference) {
        GridFS gfs = new GridFS(this.getDB(writeConcern, readPreference, this.dbName, true));
        GridFSInputFile f2 = gfs.createFile(b);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(InputStream is) throws UnknownHostException {
        GridFS gfs = new GridFS(this.getDB(null, null, null, false));
        GridFSInputFile f2 = gfs.createFile(is);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(String name) throws IOException {
        GridFS gfs = new GridFS(this.getDB(null, null, null, false));
        GridFSInputFile f2 = gfs.createFile(name);
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(File f) {
        GridFS gfs = new GridFS(this.getDB(null, null, null, false));
        GridFSInputFile f2 = null;
        try {
            f2 = gfs.createFile(f);
        }
        catch (IOException e) {
            this.logger.error("problem in creation remote file " + f.getAbsolutePath());
            this.close();
            throw new RemoteBackendException(e.getMessage());
        }
        return f2;
    }

    protected GridFSInputFile createGFSFileObject(byte[] b) {
        GridFS gfs = new GridFS(this.getDB(null, null, null, false));
        GridFSInputFile f2 = gfs.createFile(b);
        return f2;
    }

    protected void buildDirTree(DBCollection meta, String dir) {
        String[] dirTree = dir.split("/");
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("/");
        for (int i = 1; i < dirTree.length; ++i) {
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"name", (Object)dirTree[i]);
            query.put((Object)"dir", (Object)strBuff.toString());
            query.put((Object)"type", (Object)"dir");
            DBObject f = meta.findOne((DBObject)query);
            if (f == null) {
                BasicDBObject newDir = new BasicDBObject();
                newDir.put((Object)"$set", (Object)new BasicDBObject().append("name", (Object)dirTree[i]).append("dir", (Object)strBuff.toString()).append("type", (Object)"dir"));
                if (this.memoryType != MemoryType.VOLATILE) {
                    meta.update((DBObject)query, (DBObject)newDir, true, true, DEFAULT_WRITE_TYPE);
                } else {
                    meta.update((DBObject)query, (DBObject)newDir, true, true);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" Create new  object with name: " + dirTree[i] + " dir: " + strBuff.toString() + " type= dir");
                }
            }
            strBuff.append(dirTree[i] + "/");
        }
    }

    protected String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void printObject(DBObject obj) {
        Set keys = obj.keySet();
        for (String key : keys) {
            this.logger.debug(" " + key + " " + obj.get(key));
        }
    }

    protected void saveGFSFileObject(GridFSInputFile f2) {
        f2.save();
    }

    protected void clean() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        this.mongo = null;
        if (this.db != null) {
            this.db = null;
        }
    }

    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        this.logger.info("Mongo has been closed");
        this.mongo = null;
        this.gfs = null;
        this.db = null;
    }

    protected void removeGFSFile(GridFSDBFile f, ObjectId idF) {
        f.put("onDeleting", (Object)"true");
        f.save();
        this.getGfs().remove(idF);
    }

    protected void replaceGFSFile(GridFSDBFile f, ObjectId idToRemove) {
        f.put("onDeleting", (Object)"true");
        f.save();
        this.getGfs().remove(idToRemove);
    }

    private GridFS getGfs() {
        if (this.gfs == null) {
            this.gfs = new GridFS(this.getDB(null, null, this.dbName, false));
        }
        return this.gfs;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
}

