/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewTTL
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public RenewTTL(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType(), this.dbNames);
        long ttl = -1L;
        try {
            myFile.setRemotePath(this.bucket);
            ttl = tm.renewTTL(myFile);
        }
        catch (Throwable e) {
            tm.close();
            throw new RemoteBackendException(" Error in renew TTL operation ", e.getCause());
        }
        return ttl + "";
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName;
        this.localPath = file.getLocalPath();
        this.remotePath = remotePath;
        this.bucket = bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

