/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.GetSize;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMetaInfo
extends Operation {
    final Logger logger = LoggerFactory.getLogger(GetSize.class);
    public String file_separator = "/";

    public GetMetaInfo(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType(), this.dbNames);
        String value = null;
        try {
            value = tm.getFileProperty(this.bucket, myFile.getGenericPropertyField());
        }
        catch (Exception e) {
            tm.close();
            throw new RemoteBackendException(" Error in GetMetaFile operation ", e.getCause());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" PATH " + this.bucket);
        }
        return value;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String[] dirs = remotePath.split(this.file_separator);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remotePath: " + remotePath);
        }
        String buck = null;
        boolean isId = ObjectId.isValid((String)remotePath);
        if (!isId) {
            this.bucket = buck = new BucketCoding().bucketFileCoding(remotePath, rootArea);
            return this.bucket;
        }
        this.bucket = remotePath;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        throw new IllegalArgumentException("method not compatible with getMetaInfo operation");
    }
}

