/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.directoryOperation;

import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBucket {
    final Logger logger = LoggerFactory.getLogger(DirectoryBucket.class);
    public String file_separator = "/";
    String author;
    String fileName;
    String path;
    String[] server;
    String user;
    String password;

    public DirectoryBucket(String[] server, String user, String password, String path, String author) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DirectoryBucket PATH: " + path);
        }
        this.path = path;
        this.author = author;
        this.server = server;
        this.user = user;
        this.password = password;
    }

    public String[] retrieveBucketsName(String path, String rootArea) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("retrieveBucketsName() - start");
        }
        String pathCoded = new BucketCoding().mergingPathAndDir(rootArea, path);
        String[] splits = pathCoded.split(this.file_separator);
        String[] buckets = new String[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("splits[" + i + "] = " + splits[i]);
            }
            if (i > 0) {
                if (i == splits.length - 1) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("splits[" + i + "]= " + splits[i]);
                    }
                    this.fileName = buckets[i - 1] + splits[i];
                    buckets[i] = buckets[i - 1] + splits[i];
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("fileName: " + this.fileName);
                    break;
                }
                buckets[i] = buckets[i - 1] + splits[i] + "_-_";
            } else {
                buckets[i] = "_-_";
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("buckets[" + i + "]= " + buckets[i]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("retrieveBucketsName() - end");
        }
        return buckets;
    }

    @Deprecated
    public void removeKeysOnDirBucket(MyFile resource, String bucket, String rootArea, String backendType, String[] dbNames) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CHECK REMOVE: " + bucket);
        }
        String[] bucketList = null;
        bucketList = this.retrieveBucketsName(this.path, rootArea);
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(backendType, resource.getGcubeMemoryType(), dbNames);
        for (int i = 0; i < bucketList.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("REMOVE: check " + bucketList[i]);
            }
            if (!bucketList[i].equalsIgnoreCase(bucket)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing key file: " + bucketList[i] + " from dir: " + bucketList[i - 1]);
            }
            try {
                tm.getValues(resource, bucketList[i - 1], DirectoryEntity.class);
                continue;
            }
            catch (MongoException e) {
                tm.close();
                e.printStackTrace();
            }
        }
    }

    public String removeDirBucket(MyFile resource, String bucket, String rootArea, String backendType, String[] dbNames) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CHECK REMOVE: " + bucket);
        }
        String[] bucketList = null;
        BucketCoding bc = new BucketCoding();
        String bucketDirCoded = bc.bucketDirCoding(bucket, rootArea);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketDir Coded: " + bucketDirCoded);
        }
        bucketList = this.retrieveBucketsName(bucket, rootArea);
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(backendType, resource.getGcubeMemoryType(), dbNames);
        for (int i = 0; i < bucketList.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("REMOVE: check " + bucketList[i] + " bucketDirCoded: " + bucketDirCoded);
            }
            if (!bucketDirCoded.contains(bucketList[i])) continue;
            Map<String, StorageObject> map = null;
            try {
                map = tm.getValues(resource, bucketList[i], DirectoryEntity.class);
            }
            catch (MongoException e) {
                tm.close();
                e.printStackTrace();
            }
            Set<String> keys = map.keySet();
            for (String key : keys) {
                if (!key.equalsIgnoreCase(bucketDirCoded)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("key matched: " + key + " remove");
                }
                try {
                    map = tm.getValues(resource, key, DirectoryEntity.class);
                }
                catch (MongoException e) {
                    tm.close();
                    e.printStackTrace();
                }
                keys = map.keySet();
                for (String key2 : keys) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("the bucket: " + key + " have a son: " + key2);
                    }
                    if (bc.isFileObject(key2)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("remove " + key2 + " in the bucket: " + key);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("remove all keys in the bucket: " + key2);
                        }
                        try {
                            tm.removeRemoteFile(key2, resource);
                        }
                        catch (UnknownHostException e) {
                            tm.close();
                            e.printStackTrace();
                        }
                        catch (MongoException e) {
                            tm.close();
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(key2 + " is a directory");
                    }
                    String bucketDecoded = bc.bucketDirDecoding(key2, rootArea);
                    this.removeDirBucket(resource, bucketDecoded, rootArea, backendType, dbNames);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove " + key + " in the bucket: " + bucketList[i]);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove all keys in the bucket: " + key);
                }
                try {
                    tm.removeRemoteFile(key, resource);
                }
                catch (UnknownHostException e) {
                    tm.close();
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    tm.close();
                    e.printStackTrace();
                }
            }
        }
        return bucketDirCoded;
    }

    public String searchInBucket(MyFile resource, String name, String bucketCoded, TransportManager tm, String rootArea) {
        Map<String, StorageObject> dirs = null;
        try {
            dirs = tm.getValues(resource, bucketCoded, DirectoryEntity.class);
        }
        catch (Exception e) {
            tm.close();
            this.logger.info("object not found");
            return null;
        }
        Set<String> set = dirs.keySet();
        for (String key : set) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("try in " + key);
            }
            String nameDecoded = new BucketCoding().bucketFileDecoding(key, rootArea);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("name decoded: " + nameDecoded + " name searched is: " + name);
            }
            if (nameDecoded != null && nameDecoded.equalsIgnoreCase(name)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("FOUND in " + bucketCoded + " objectId returned: " + key);
                }
                return key;
            }
            this.searchInBucket(resource, name, key, tm, rootArea);
        }
        return null;
    }
}

