/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.freshcookies.security.policy.PolicyException;
import org.freshcookies.security.policy.PolicyReader;

public class LocalPolicy {
    private boolean loaded = false;
    private final File policyFile;
    private final Set pds;
    private final String charset;

    public LocalPolicy(File file) {
        this(file, (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("file.encoding");
            }
        }));
    }

    public LocalPolicy(File file, String encoding) {
        this.policyFile = file;
        this.pds = new HashSet();
        this.charset = encoding;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (!this.loaded) {
            try {
                this.refresh();
            }
            catch (PolicyException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        Iterator it = this.pds.iterator();
        while (it.hasNext()) {
            PermissionCollection permissions;
            LocalProtectionDomain pd = (LocalProtectionDomain)it.next();
            boolean samePrincipals = this.samePrincipals(pd.getPrincipals(), domain.getPrincipals());
            boolean sameCodeSource = pd.getCodeSource().implies(domain.getCodeSource());
            boolean sameClassLoader = pd.getClassLoader().equals(domain.getClassLoader());
            if (!samePrincipals || !sameCodeSource || !sameClassLoader || !(permissions = pd.getPermissions()).implies(permission)) continue;
            return true;
        }
        return false;
    }

    protected boolean samePrincipals(Principal[] p1, Principal[] p2) {
        int i;
        if (p1.length != p2.length) {
            return false;
        }
        ArrayList<Principal> leftovers = new ArrayList<Principal>();
        for (i = 0; i < p2.length; ++i) {
            leftovers.add(p2[i]);
        }
        block1: for (i = 0; i < p1.length; ++i) {
            Principal p = p1[i];
            Iterator it = leftovers.iterator();
            while (it.hasNext()) {
                Principal leftover = (Principal)it.next();
                if (!((Object)p).equals(leftover)) continue;
                it.remove();
                continue block1;
            }
        }
        return leftovers.size() == 0;
    }

    public void refresh() throws PolicyException {
        PolicyReader reader;
        this.pds.clear();
        try {
            reader = new PolicyReader(this.policyFile, this.charset);
            reader.read();
        }
        catch (IOException e) {
            String msg = "Problems refreshing policy from file " + this.policyFile + ": " + e.getMessage();
            System.err.println(msg);
            throw new PolicyException(msg);
        }
        if (!reader.isValid()) {
            List messages = reader.getMessages();
            Iterator it = messages.iterator();
            while (it.hasNext()) {
                String message = (String)it.next();
                System.err.println(message);
            }
            StringBuffer s = new StringBuffer();
            Iterator it2 = messages.iterator();
            while (it2.hasNext()) {
                s.append((String)it2.next());
            }
            throw new PolicyException("Errors parsing policy from file " + this.policyFile + ": " + s.toString());
        }
        ProtectionDomain[] parsedPds = reader.getProtectionDomains();
        for (int i = 0; i < parsedPds.length; ++i) {
            ProtectionDomain pd = parsedPds[i];
            LocalProtectionDomain localPd = new LocalProtectionDomain(pd.getCodeSource(), pd.getPermissions(), pd.getClassLoader(), pd.getPrincipals());
            this.pds.add(localPd);
        }
        this.loaded = true;
    }

    public static class LocalProtectionDomain {
        private final CodeSource codesource;
        private final ClassLoader classloader;
        private final PermissionCollection permissions;
        private final Principal[] principals;

        public LocalProtectionDomain(CodeSource codesource, PermissionCollection permissions, ClassLoader classloader, Principal[] principals) {
            this.codesource = codesource;
            this.permissions = permissions;
            if (permissions != null && !permissions.isReadOnly()) {
                permissions.setReadOnly();
            }
            this.classloader = classloader;
            this.principals = principals == null ? new Principal[]{} : principals;
        }

        public ClassLoader getClassLoader() {
            return this.classloader;
        }

        public Principal[] getPrincipals() {
            return this.principals;
        }

        public PermissionCollection getPermissions() {
            return this.permissions;
        }

        public CodeSource getCodeSource() {
            return this.codesource;
        }
    }
}

