/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.security.AccessControlException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.NodeTypePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.PrefixPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.AbstractRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

@Component
@Service(value={RestrictionProvider.class})
public class RestrictionProviderImpl
extends AbstractRestrictionProvider {
    public RestrictionProviderImpl() {
        super(RestrictionProviderImpl.supportedRestrictions());
    }

    private static Map<String, RestrictionDefinition> supportedRestrictions() {
        RestrictionDefinitionImpl glob = new RestrictionDefinitionImpl("rep:glob", Type.STRING, false);
        RestrictionDefinitionImpl nts = new RestrictionDefinitionImpl("rep:ntNames", Type.NAMES, false);
        RestrictionDefinitionImpl pfxs = new RestrictionDefinitionImpl("rep:prefixes", Type.STRINGS, false);
        return ImmutableMap.of((Object)glob.getName(), (Object)glob, (Object)nts.getName(), (Object)nts, (Object)pfxs.getName(), (Object)pfxs);
    }

    @Override
    public RestrictionPattern getPattern(String oakPath, Tree tree) {
        PropertyState prefixes;
        PropertyState ntNames;
        if (oakPath == null) {
            return RestrictionPattern.EMPTY;
        }
        PropertyState glob = tree.getProperty("rep:glob");
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>(2);
        if (glob != null) {
            patterns.add(GlobPattern.create(oakPath, glob.getValue(Type.STRING)));
        }
        if ((ntNames = tree.getProperty("rep:ntNames")) != null) {
            patterns.add(new NodeTypePattern(ntNames.getValue(Type.NAMES)));
        }
        if ((prefixes = tree.getProperty("rep:prefixes")) != null) {
            patterns.add(new PrefixPattern(prefixes.getValue(Type.STRINGS)));
        }
        switch (patterns.size()) {
            case 1: {
                return (RestrictionPattern)patterns.get(0);
            }
            case 2: {
                return new CompositePattern(patterns);
            }
        }
        return RestrictionPattern.EMPTY;
    }

    @Override
    public void validateRestrictions(String oakPath, Tree aceTree) throws AccessControlException {
        super.validateRestrictions(oakPath, aceTree);
        Tree restrictionsTree = this.getRestrictionsTree(aceTree);
        PropertyState glob = restrictionsTree.getProperty("rep:glob");
        if (glob != null) {
            GlobPattern.validate(glob.getValue(Type.STRING));
        }
    }
}

