/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.backup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.plugins.backup.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.plugins.backup.FileStoreRestore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBackupRestore
implements FileStoreBackupRestoreMBean {
    private static final Logger log = LoggerFactory.getLogger(FileStoreBackupRestore.class);
    public static final String BACKUP_OP_NAME = "Backup";
    public static final String RESTORE_OP_NAME = "Restore";
    private final NodeStore store;
    private final File file;
    private final Executor executor;
    private ManagementOperation backupOp = ManagementOperation.done("Backup", 0L);
    private ManagementOperation restoreOp = ManagementOperation.done("Restore", 0L);

    public FileStoreBackupRestore(@Nonnull NodeStore store, @Nonnull File file, @Nonnull Executor executor) {
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public synchronized CompositeData startBackup() {
        if (this.backupOp.isDone()) {
            this.backupOp = new ManagementOperation(BACKUP_OP_NAME, new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreBackup.backup(FileStoreBackupRestore.this.store, FileStoreBackupRestore.this.file);
                    return System.nanoTime() - t0;
                }
            });
            this.executor.execute(this.backupOp);
        }
        return this.getBackupStatus();
    }

    @Override
    public synchronized CompositeData getBackupStatus() {
        return this.backupOp.getStatus().toCompositeData();
    }

    @Override
    public synchronized CompositeData startRestore() {
        if (this.restoreOp.isDone()) {
            this.restoreOp = new ManagementOperation(RESTORE_OP_NAME, new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    long t0 = System.nanoTime();
                    FileStoreRestore.restore(FileStoreBackupRestore.this.file, FileStoreBackupRestore.this.store);
                    return System.nanoTime() - t0;
                }
            });
            this.executor.execute(this.restoreOp);
        }
        return this.getRestoreStatus();
    }

    @Override
    public synchronized CompositeData getRestoreStatus() {
        return this.restoreOp.getStatus().toCompositeData();
    }

    @Override
    public String checkpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }
}

